<?php

namespace Adfox\FieldTemplate\Filament\Resources;

use Adfox\FieldTemplate\Filament\Resources\FieldTemplateResource\Pages;
use Adfox\FieldTemplate\Filament\Resources\FieldTemplateResource\RelationManagers;
use App\Filament\Clusters\DynamicFields;
use App\Models\FieldTemplate;
use Filament\Forms;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\ToggleColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;

class FieldTemplateResource extends Resource implements HasShieldPermissions
{
    protected static ?string $model = FieldTemplate::class;

    protected static ?string $navigationIcon = 'heroicon-o-document-duplicate';

    protected static ?string $cluster = DynamicFields::class;

    protected static ?int $navigationSort = 2;

    // protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function getPermissionPrefixes(): array
    {
        return [
            'create',
            'update',
            'view_any',
            'delete',
            'delete_any'
        ];
    }


    public static function canViewAny(): bool
    {
        return userHasPermission('view_any_field::template');
    }

    public static function canCreate(): bool
    {
        return userHasPermission('create_field::template');
    }

    public static function canEdit($record): bool
    {
        return userHasPermission('update_field::template');
    }

    public static function canDelete($record): bool
    {
        return userHasPermission('delete_field::template');
    }

    public static function canDeleteAny(): bool
    {
        return userHasPermission('delete_any_field::template');
    }


    public static function getModelLabel(): string
    {
        return __('messages.t_ap_field_template');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('name')
                ->label(__('messages.t_ap_name'))
                ->unique(ignoreRecord: true)
                ->required()
                ->disabled(function ($record) {
                    if($record){
                        return $record->default;
                    }
                })
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->columns([
                TextColumn::make('name')
                ->label(__('messages.t_ap_name')),
                ToggleColumn::make('enable')
                ->label(__('messages.t_ap_enable'))
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make()
                ->hidden(fn($record)=>$record->default)
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->checkIfRecordIsSelectableUsing(
                fn (Model $record): bool => !$record->default);
    }

    public static function getRelations(): array
    {
        return [
            RelationManagers\FieldTemplateMappingsRelationManager::class
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListFieldTemplates::route('/'),
            'create' => Pages\CreateFieldTemplate::route('/create'),
            'edit' => Pages\EditFieldTemplate::route('/{record}/edit'),
        ];
    }
}
