<?php

namespace Adfox\FieldTemplate\Filament\Resources\FieldTemplateResource\RelationManagers;

use Adfox\FieldTemplate\Filament\Resources\FieldTemplateResource\Pages\CreateFieldTemplate;
use App\Filament\Resources\FieldResource;
use App\Models\Field;
use App\Models\FieldGroup;
use App\Models\FieldTemplateMappings;
use Closure;
use Filament\Forms;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TagsInput;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Resources\RelationManagers\RelationManager;

class FieldTemplateMappingsRelationManager extends RelationManager
{
    protected static string $relationship = 'fieldTemplateMappings';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Select::make('field_id')
                ->searchable()
                ->preload()
                ->options(Field::orWhereHas('fieldTemplateMappings', function ($query) {
                    $query->orWhereNot('field_template_id', $this->getOwnerRecord()->id);
                })->pluck('name','id'))

                    // TODO : validating when field name is already mapped.
                    // ->rules([
                    //     fn(): Closure => function (string $attribute, $value, Closure $fail) {
                    //         $field = Field::find($value);
                    //         $fieldTemplate = $this->getOwnerRecord();
                    //         $existingFieldCount = FieldTemplateMappings::where('field_template_id',$fieldTemplate->id)->whereHas('field', function (Builder $query) use ($field) {
                    //             $query->where('name', $field->name);
                    //         })->count();

                    //         if ($existingFieldCount) {
                    //             $fail("The {$field->name} field name is already mapped.");
                    //         }
                    //     },
                    // ])
            ]);
    }


    public function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->recordTitleAttribute('field_template_id')
            ->reorderable('order')
            ->columns([
                Tables\Columns\TextColumn::make('field.name')
                ->label(__('Field Name'))
                ->searchable(),
                Tables\Columns\TextColumn::make('field.type')
                    ->formatStateUsing(fn($state): string => $state->getLabel())
                    ->badge()
                    ->label(__('Field Type')),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make()
                    ->label(__('Add Fields to Template'))
                    ->modalHeading(__('Add Fields to Template')),
            ])
            ->actions([
                Tables\Actions\EditAction::make()
                    ->url(fn($record) => route('filament.admin.dynamic-fields.resources.fields.edit', [$record->field->id, 'from' => 'field-template', 'id' => $record->id])),
                Tables\Actions\DeleteAction::make()
                    ->hidden(fn($record) => $record->default )

            ])
            ->bulkActions([

            ])
            ->emptyStateActions([
            ]);
    }
}
