<?php

namespace Adfox\GoogleLocationKit\Filament\Pages;


use App\Settings\GoogleLocationKitSettings;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Illuminate\Support\Facades\Config;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class GoogleLocation extends SettingsPage
{
    use HasPageShield;


    protected static ?string $slug = 'manage-google-location-settings';

    protected static string $settings = GoogleLocationKitSettings::class;

    protected static ?int $navigationSort = 12; // Adjust the sort order as needed

    public static function getNavigationBadgeTooltip(): ?string
    {
        return 'Google Location Module (Addon) - Enable precise location search for ads using Google Maps API with autocomplete suggestions. Requires separate purchase.';
    }

    public static function getNavigationBadge(): ?string
    {
        $isDemo = Config::get('app.demo');
        return  $isDemo  ? 'Addon' : '';
    }

    public static function getNavigationBadgeColor(): ?string
    {
        return 'danger';
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_GoogleLocation');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_google_location');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_settings');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_google_location');
    }
    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(GoogleLocationKitSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $isDemo = Config::get('app.demo');
        return $form
            ->schema([
                Toggle::make('status')
                    ->label(__('messages.t_ap_enable_google_location'))
                    ->columnSpanFull()
                    ->helperText(__('messages.t_ap_enable_google_location_helper')),

                $isDemo ?
                Placeholder::make('api_key')
                    ->label(__('messages.t_ap_google_api_key'))
                    ->content('*****')
                    ->hint(__('messages.t_ap_google_api_key_hidden_demo')) :
                TextInput::make('api_key')
                    ->label(__('messages.t_ap_google_api_key'))
                    ->required()
                    ->helperText(__('messages.t_ap_google_api_key_helper')),

                Toggle::make('enable_zip_code_search')
                    ->label(__('messages.t_ap_enable_zip_code_search'))
                    ->columnSpanFull()
                    ->helperText(__('messages.t_ap_enable_zip_code_search_helper')),

            ])
            ->columns(2);
    }
}
