<?php

namespace Adfox\MapView\Filament\Pages;

use App\Settings\FeedbackSettings;
use App\Settings\MapViewSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Illuminate\Contracts\Support\Htmlable;
use Illuminate\Support\HtmlString;
use Filament\Forms\Get;
use Filament\Forms\Set;
use Illuminate\Support\Facades\Config;

class ManageMapViewSettings extends SettingsPage
{

    protected static ?string $slug = 'manage-map-view-settings';

    protected static string $settings = MapViewSettings::class;

    protected static ?int $navigationSort = 5;

    public static function getNavigationBadgeTooltip(): ?string
    {
        return 'Map View Module (Addon) - Display listing results on Google Maps for location-based browsing. Requires separate purchase.';
    }

    public static function getNavigationBadge(): ?string
    {
        $isDemo = Config::get('app.demo');
        return  $isDemo  ? 'Addon' : '';
    }

    public static function getNavigationBadgeColor(): ?string
    {
        return 'danger';
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_ManageMapViewSettings');
    }

    public function getTitle(): string|Htmlable
    {
        return __('messages.t_ap_map_view_settings');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_map_view');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_content_design');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('enable')
                ->label(__('messages.t_ap_enable_map_view'))
                ->live()
                ->afterStateUpdated(fn(Set $set) => $set('show_filter_popup', false))
                ->helperText(new HtmlString(__('messages.t_ap_enable_map_view_helper_text', ['route' => route('filament.admin.pages.manage-google-location-settings')]))),

                Toggle::make('show_filter_popup')
                    ->label(__('messages.t_ap_display_filter_in_popup'))
                    ->disabled(function(Get $get){
                        return !$get('enable');
                    })
                    ->helperText(__('messages.t_ap_display_filter_in_popup_helper_text')),

                Toggle::make('enable_container_max_width')
                    ->label(__('messages.t_ap_enable_container_max_width'))
                    ->helperText(__('messages.t_ap_enable_container_max_width_helper_text')),

                Select::make('map_marker_display_type')
                    ->label(__('messages.t_ap_map_marker_display_type'))
                    ->options([
                        'price' => __('messages.t_ap_display_ad_price'),
                        'count' => __('messages.t_ap_display_ad_count'),
                    ])
                    ->helperText(function ($state) {
                        $text = '';
                        if ($state == 'price') {
                            $text = __('messages.t_ap_display_ad_price_description');
                        } elseif ($state == 'count') {
                            $text = __('messages.t_ap_display_ad_count_description');
                        } else {
                            $text = __('messages.t_ap_choose_map_marker_display');
                        }
                        return new HtmlString($text);
                    })
                    ->required(),
                Toggle::make('show_map_in_fullscreen')
                    ->label(__('messages.t_ap_show_map_in_fullscreen'))
                    ->disabled(function(Get $get){
                        return !$get('enable');
                    })
                    ->helperText(__('messages.t_ap_show_map_in_fullscreen_helper_text')),

            ])
            ->columns(2);
    }
}
