<?php


namespace Adfox\MapView\Livewire;


use App\Models\Ad;
use App\Settings\GoogleLocationKitSettings;
use App\Settings\MapViewSettings;
use Illuminate\Pagination\Paginator;
use Livewire\Component;
use Livewire\Attributes\On;
use Livewire\Attributes\Reactive;


class MapView extends Component
{
    public $ads = [];
    public $adsCountByLocation = [];
    public $selectedAdId = null;
    public $selectedAd = null;


    public function mount()
    {
        // $this->adRender($adData);
    }


    #[On('select-ad')]
    public function selectAd($adId)
    {
        $this->selectedAdId = $adId;
        $this->selectedAd = Ad::find($this->selectedAdId);
    }


    public function getMapViewSettingsProperty()
    {
        return app(MapViewSettings::class);
    }


    public function getCanDisplayLocationCountProperty()
    {
        return $this->mapViewSettings->map_marker_display_type == 'count';
    }
    public function getGoogleSettingsProperty()
    {
        return app(GoogleLocationKitSettings::class);
    }
    #[On('ads-map-updated')]
    public function adRender($ads)
    {
        $this->ads = Ad::whereIn('id',$ads)->get();
    }


    public function render()
    {
        return view('map-view::map-view');
    }
}
