<?php

namespace Adfox\MapView\Providers;

use Adfox\MapView\Livewire\MapView;
use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Adfox\MapView\MapViewPlugin;
use Livewire\Livewire;

class MapViewServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(function (Panel $panel) {
                $panel->plugin(new MapViewPlugin());
        });
    }

    public function boot()
    {
        Livewire::component('map-view', MapView::class);
    }

}
