<x-filament-panels::page>
    <style>
        /* In CSS */
        :root {
            --icon-bg-color: none;
        }

        .fi-ta-empty-state-icon-ctn {
            background-color: var(--icon-bg-color);
        }

        /* Hide element in dark mode */
        .dark .fi-ta-empty-state-icon-ctn {
            background-color: var(--icon-bg-color);
        }
    </style>

<style>
    /* In CSS */
    :root {
        --icon-bg-color: none;
    }

    .fi-ta-empty-state-icon-ctn {
        background-color: var(--icon-bg-color);
    }

    .fi-ta-empty-state-icon-ctn > svg{
        width: 10rem;
        height: 10rem;
    }

    /* Hide element in dark mode */
    .dark .fi-ta-empty-state-icon-ctn {
        background-color: var(--icon-bg-color);
    }
</style>

    <div class="">
        <x-package-prompt />
        <div>
            {{ $this->table }}
        </div>
    </div>

    <script>
        const intervalId2 = setInterval(() => {
            // Select all elements that should receive the SVG update
            const listContainers = document.querySelectorAll('.fi-ta-empty-state-icon-ctn');

            // Define the new SVG content
            const newSVG = `
                   <svg class="w-40" viewBox="0 0 149 149" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M116.524 89.5334C118.648 90.8967 118.804 90.3752 116.331 93.5862C115.876 94.1747 116.286 94.1673 112.852 91.8131C111.429 90.8446 111.749 92.0738 113.269 88.4978C113.269 88.4308 113.269 88.4978 113.649 87.7528C114.602 88.2892 115.914 89.1236 116.524 89.5334Z" fill="white"/>
            <path d="M141.75 105.469C142.252 105.824 142.616 106.344 142.777 106.938C142.939 107.532 142.889 108.163 142.636 108.725C142.239 109.57 141.697 110.339 141.034 110.997C138.314 112.837 138.963 112.852 131.841 107.331C118.193 96.745 115.123 95.4114 115.838 95.2401C116.673 95.0538 117.328 94.1226 118.073 93.1988C118.677 92.5757 119.106 91.8049 119.318 90.9638C119.481 89.8463 118.573 89.2428 130.344 97.9146C134.791 101.178 131.036 98.5628 141.75 105.469Z" fill="#FEBD69"/>
            <path d="M115.688 70.7526C117.506 80.2432 111.218 92.3569 99.9168 96.5363C95.3629 98.2381 90.359 98.304 85.7618 96.7226C83.7082 96.326 81.7409 95.5693 79.9508 94.4876C78.5609 93.7104 77.2722 92.7646 76.1141 91.6715C71.0779 87.3505 68.2171 82.3813 68.083 75.7508C68.0159 72.7261 67.9116 71.9588 68.1277 70.8413C68.4504 67.7549 69.385 64.7639 70.8767 62.0428C79.2878 47.1428 100.596 45.0643 112.27 61.3425C114.028 63.8457 115.107 67.7577 115.688 70.7526ZM93.3832 93.5489C104.141 92.9603 115.041 81.6289 110.839 68.3679C109.141 63.0411 106.942 61.3202 105.162 59.6886C95.2755 50.6369 79.3183 54.3246 74.5056 64.4566C71.8832 69.9771 72.0695 73.9256 72.9635 79.3566C73.108 80.0271 73.3196 80.6812 73.5967 81.3085C73.945 82.2912 74.418 83.2251 75.004 84.0874C78.3044 90.0101 86.6186 93.9214 93.3832 93.5489Z" fill="#FEBD69"/>
            <path d="M111.95 92.9679C112.062 96.2235 112.651 120.533 112.516 121.889C112.516 122.127 112.412 122.254 112.174 122.291C107.257 123.118 106.772 122.827 103.331 123.036C103.07 123.036 62.7951 124.936 62.7728 124.928C57.4162 124.846 43.6412 126.418 43.6114 124.601C43.5667 121.978 43.5294 122.537 43.5294 121.904C43.5294 121.27 43.3283 121.524 45.7644 121.069C45.7644 121.069 54.3915 119.319 57.1108 119.184C59.681 119.058 58.0271 118.626 80.0195 115.377C84.4895 114.714 103.241 111.965 108.754 109.745C109.782 109.336 109.119 107.995 107.018 94.0109C106.966 93.6607 108.56 92.7593 109.872 91.3289C110.095 91.083 110.177 91.2171 111.31 91.9919C111.764 92.2974 111.928 92.2601 111.95 92.9679Z" fill="white"/>
            <path d="M110.705 56.2996C110.705 57.3724 111.07 57.8939 109.781 56.5231C109.118 55.8228 109.14 56.0761 108.455 55.4131C107.3 54.3754 106.053 53.4453 104.73 52.6342C104.447 52.4405 104.409 52.3437 101.891 51.1889C100.997 50.7717 100.729 50.876 100.677 50.3992C100.677 50.28 99.7083 44.7 99.0006 39.3583C98.9261 38.7549 99.1347 39.8053 98.3003 34.0688C98.1215 32.8023 97.9725 32.7502 98.4046 32.698C99.008 32.6235 106.555 32.2212 107.531 32.2287C109.58 32.2436 110.176 29.6659 110.705 56.2996Z" fill="white"/>
            <path d="M86.3055 22.2606C92.5337 27.2745 97.6891 29.6212 95.6776 30.6419C95.5286 30.7164 89.7176 32.7726 88.3617 33.1376C87.3634 33.4058 85.7095 33.6815 85.6573 32.6385C85.599 30.1434 85.3775 27.6547 84.9943 25.1885C84.9631 24.1404 84.866 23.0954 84.7037 22.0595C84.4877 20.4428 84.3461 20.6887 86.3055 22.2606Z" fill="white"/>
            <path d="M105.937 94.9495C106.474 99.3599 108.515 108.248 107.874 108.725C104.76 111.071 54.5992 117.888 46.434 119.765C44.9887 120.093 38.1422 120.756 37.8591 120.555C37.7771 120.488 37.7399 119.289 37.4866 118.417C37.2333 117.545 36.7788 113.753 36.7416 113.537C33.1954 95.5902 31.169 81.9716 29.5896 69.8951C29.001 65.4251 28.2411 63.0709 27.8388 59.1597C27.4663 55.5911 27.0938 55.5762 26.8778 53.073C26.1328 45.2282 24.166 40.043 23.8978 31.699C23.8382 29.7471 23.2198 30.8124 37.941 28.0336C46.5979 26.402 46.9928 27.0278 56.0967 25.4633C68.7617 23.2805 65.7817 23.9733 67.6144 23.6828C67.6144 23.6828 82.3505 20.7847 83.0359 20.6357C83.8703 20.4495 83.7809 24.1745 84.1012 26.8863C84.3485 28.8993 84.4908 30.9235 84.5259 32.9506C84.5598 33.2005 84.6439 33.4409 84.7732 33.6574C84.9026 33.8739 85.0744 34.0619 85.2784 34.2102C85.4823 34.3585 85.7142 34.4639 85.9601 34.5202C86.2059 34.5764 86.4605 34.5823 86.7087 34.5374C87.6702 34.4946 88.6197 34.3062 89.5248 33.9787C96.6097 31.8405 96.5427 31.2669 96.6544 31.7437C97.2057 34.0979 98.5319 45.3176 99.0683 48.2454C99.4333 50.2346 99.5823 50.2867 98.7851 50.0185C88.601 46.6362 74.9899 51.3074 69.6929 61.4841C65.0367 70.4241 65.8934 84.2736 73.485 90.9265C77.8134 94.7185 79.6685 96.5885 87.7666 98.518C89.9822 98.8771 92.2314 98.9874 94.4716 98.8458C103.464 97.8252 105.803 93.7873 105.937 94.9495ZM58.4732 45.2133C64.4854 43.2167 60.9168 41.4883 59.9632 41.9502C59.4641 42.1737 58.9724 42.3972 58.4732 42.643C57.7729 43.0006 57.7282 42.3525 57.2663 42.2482C55.8285 41.9129 55.6944 42.0992 53.7127 43.2688C52.4089 44.0138 52.2897 44.431 51.6863 43.8425C50.4272 42.6281 48.8553 42.8144 47.3057 43.6711C44.3257 45.3101 45.3612 45.109 43.1635 45.0866C41.9789 45.0866 40.9285 44.6471 39.3193 45.6528C37.0843 47.0385 39.1181 45.4815 36.3393 45.2058C35.5123 45.1239 33.8063 46.2116 33.1954 46.6437C32.3312 47.2546 31.5266 47.8133 31.616 48.7967C31.6238 48.9661 31.6817 49.1294 31.7824 49.2658C31.8831 49.4023 32.022 49.5058 32.1816 49.5632C32.3411 49.6206 32.5141 49.6294 32.6787 49.5885C32.8432 49.5475 32.9919 49.4587 33.106 49.3331C33.9194 48.5483 34.8718 47.9217 35.9146 47.4855C36.6075 47.1801 35.9966 48.5956 37.5983 48.834C38.5743 48.9755 38.8425 48.5062 40.9508 47.4557C41.599 47.1354 42.1801 47.4557 43.5658 47.56C46.5458 47.858 48.7808 44.0213 50.4496 45.6007C52.8932 47.9549 55.8657 43.7903 56.4766 44.5949C56.7039 44.8927 57.0183 45.1122 57.3762 45.223C57.734 45.3338 58.1174 45.3304 58.4732 45.2133ZM52.3419 36.832C52.3419 36.087 51.5075 36.0051 51.3436 35.938C50.7997 35.722 50.3751 36.1243 49.9057 36.2733C48.6765 36.6607 48.6616 35.9753 46.8736 36.467C44.2512 37.212 44.2139 37.957 43.6626 37.51C43.3125 37.2269 43.2231 37.0481 42.709 37.0257C42.4399 36.9483 42.1579 36.9261 41.8801 36.9607C41.6022 36.9953 41.3342 37.0858 41.0924 37.2269C39.133 38.1805 38.8574 38.7988 37.9187 38.9702C37.725 38.9702 37.6579 38.8137 37.5387 38.7094C35.6986 37.0332 34.0968 37.9644 32.1673 39.1043C31.6651 39.3344 31.2287 39.6869 30.898 40.1294C30.5674 40.572 30.3532 41.0905 30.275 41.6373C30.1409 42.6281 31.6011 42.8889 31.832 42.0992C32.063 41.3095 33.9925 40.3484 34.9834 39.9387C35.9742 39.5289 35.7284 40.3186 37.129 41.0189C39.0511 41.98 41.9044 38.7169 42.2546 39.4172C42.4826 39.7183 42.7992 39.9406 43.1599 40.0528C43.5206 40.165 43.9074 40.1616 44.2661 40.043C46.5681 39 47.03 38.7914 48.0507 38.6126C48.6616 38.5083 49.2427 38.9851 50.6656 38.4561C51.6341 38.1283 52.3195 37.8676 52.3419 36.832ZM48.9298 53.5349C49.2054 52.5143 47.9389 52.2535 47.2163 52.4025C45.9274 52.6707 45.3389 53.4306 44.2363 53.0581C43.4814 52.8974 42.6944 52.9945 42.0013 53.3338C40.3399 54.0192 40.5113 54.265 40.2356 53.7659C39.2969 51.8438 36.086 53.4828 34.3874 54.7791C33.9933 55.0774 33.7271 55.514 33.6424 56.0009C33.6184 56.2009 33.6615 56.4031 33.765 56.5759C33.8684 56.7487 34.0263 56.8823 34.2139 56.9556C34.4015 57.0289 34.6081 57.0379 34.8013 56.981C34.9945 56.9242 35.1634 56.8048 35.2814 56.6416C36.1276 55.9928 37.067 55.4754 38.0677 55.1069C38.6413 54.9132 38.1869 55.7327 38.9542 56.284C40.2356 57.2003 40.9136 56.1797 43.3199 55.3229C43.6999 55.1888 43.9606 55.3974 44.3331 55.457C45.8231 55.7178 46.1435 55.2633 48.3859 54.5109C48.8329 54.3395 48.7808 54.0937 48.9298 53.5349Z" fill="white"/>
            <path d="M110.624 72.9801C110.624 73.2483 110.788 73.4048 110.766 73.4644C110.743 73.524 111.391 85.637 99.5906 90.9786C96.4539 92.3225 93.0082 92.7787 89.6299 92.2973C83.9381 91.1947 83.7817 90.2783 82.545 89.8983C82.4854 89.8983 78.075 86.9705 76.6967 84.7281C75.0859 82.6171 74.0329 80.1343 73.6348 77.509C72.8898 73.3594 73.9477 69.6195 73.9551 69.0086C75.1993 66.4309 76.436 60.5379 83.5358 57.4611C91.8053 53.8702 98.7711 55.5613 105.26 61.2829C107.905 63.5924 110.021 67.2809 110.624 72.9801Z" fill="white"/>
            <path d="M61.9818 98.2722C62.1085 98.7788 59.4488 100.507 59.0987 100.768C57.6087 101.722 57.2511 102.094 56.4465 100.835C55.0533 98.6522 54.6957 98.153 54.3828 97.11C54.3828 96.3054 55.7387 95.4114 58.0706 93.7948C58.2054 93.7453 58.3517 93.7358 58.4918 93.7675C58.6319 93.7993 58.7599 93.8708 58.8603 93.9736C59.6127 94.7856 61.7285 97.2143 61.9818 98.2722Z" fill="#FEBD69"/>
            <path d="M58.8157 66.1559C60.1716 67.7502 60.7378 70.4695 60.6037 72.5704C60.2387 77.9709 53.0196 82.575 54.4873 86.5831C55.6644 89.8089 57.7429 88.751 53.1463 92.0737C52.2895 92.6846 51.5967 93.3998 50.9113 92.5952C46.0539 86.7917 48.2963 81.0701 53.0941 75.2218C57.065 70.3868 52.1107 65.9913 46.7467 69.1054C45.1226 70.0441 43.3644 70.9083 42.3736 74.6258C42.2298 75.2144 42.1449 75.8164 42.1203 76.4213C42.0635 76.7385 41.9362 77.0389 41.7478 77.3004C41.5913 77.6356 38.8721 77.0545 37.5609 76.9055C35.0726 76.6224 36.8159 64.2405 49.0562 62.2514C54.2861 61.417 56.6701 63.6304 58.8157 66.1559Z" fill="#FEBD69"/>
            <path d="M110.838 68.3686C115.04 81.6139 104.133 92.9528 93.383 93.5488C86.6184 93.9213 78.3042 90.0101 75.0038 84.0948C74.4174 83.2326 73.9442 82.2987 73.5958 81.3159C73.3228 80.687 73.1107 80.0334 72.9625 79.364C72.0536 73.933 71.8823 69.977 74.5047 64.464C81.1277 50.5027 105.296 50.9281 110.838 68.3686ZM110.622 72.9801C109.132 59.1455 95.7223 52.1201 83.5564 57.4618C76.464 60.561 75.2199 66.4018 73.9757 69.0093C73.9757 69.6202 72.9327 73.3601 73.6554 77.509C74.0534 80.1343 75.1065 82.6171 76.7173 84.728C78.0732 86.963 82.506 89.8834 82.5656 89.8983C83.8023 90.2783 83.9587 91.1946 89.6505 92.2972C93.0291 92.7785 96.4747 92.3226 99.6112 90.9786C107.478 87.41 111.308 79.4542 110.622 72.9801Z" fill="black"/>
            <path d="M94.2393 76.8684C95.3195 77.4718 94.7384 78.5223 94.135 78.1796C92.0862 77.0099 90.842 76.3692 88.607 77.3228C86.8935 78.0678 86.3721 80.057 86.1262 80.5934C86.0219 80.8243 85.3812 81.167 85.1875 80.2209C85.4035 77.7326 88.8157 73.8288 94.2393 76.8684Z" fill="black"/>
            <path d="M87.0739 60.859C89.7708 58.4303 92.6316 59.7341 92.0803 61.1347C91.9909 61.3582 91.5141 61.3507 91.3353 61.1347C90.3966 60.0172 88.6756 60.8069 87.7444 61.7009C85.785 63.5783 84.8538 61.6115 86.0085 61.4848C86.53 61.4178 86.3438 61.5221 87.0739 60.859Z" fill="black"/>
            <path d="M89.5547 69.6799C88.8693 69.6799 88.683 68.2867 88.7575 67.6311C88.832 66.9755 90.0464 66.5956 90.2848 68.1079C90.4487 68.8827 90.3891 69.6575 89.5547 69.6799Z" fill="black"/>
            <path d="M84.0945 69.069C84.4 69.6501 84.6458 71.2071 83.9008 71.304C83.1558 71.4008 82.7602 70.0002 82.9167 69.1956C83.0359 68.5847 83.8785 68.6741 84.0945 69.069Z" fill="black"/>
            <path d="M83.3257 64.4723C83.6609 65.5749 81.6345 64.8299 81.3142 66.752C81.0981 67.6758 80.3382 67.564 80.219 67.1096C80.2112 66.5312 80.3805 65.9644 80.704 65.485C81.0276 65.0056 81.4901 64.6366 82.0294 64.4276C82.2007 64.368 83.1469 63.8837 83.3257 64.4723Z" fill="black"/>
            <path d="M57.3992 102.198C56.7361 102.198 56.3115 101.677 55.9539 101.118C52.9739 96.4618 52.7504 96.7822 57.727 93.303C57.9774 93.1699 58.2646 93.1226 58.5445 93.1683C58.8244 93.2141 59.0816 93.3504 59.2766 93.5563C59.2766 93.5563 62.1895 96.6481 62.5397 98.1008C62.6663 98.6074 62.2789 99.1215 61.0497 100.053C60.4909 100.53 58.1889 102.198 57.3992 102.198ZM54.9705 97.0504C55.261 97.9369 55.7155 98.5404 56.9298 100.492C57.3843 101.237 57.3321 101.178 58.4198 100.492C59.4792 99.8566 60.4659 99.1072 61.3626 98.2573C60.5425 96.8058 59.5133 95.4829 58.3081 94.3311C54.3521 97.1249 55.0077 97.1547 54.9705 97.0802V97.0504Z" fill="black"/>
            <path d="M51.5513 93.5489C50.3518 93.5489 47.3271 89.7345 47.6251 85.0112C48.1466 76.8907 56.5651 73.7096 53.2797 69.8654C51.7897 68.0774 49.063 68.4424 46.9174 69.6866C45.3752 70.5731 43.8554 71.4001 42.9391 74.7898C42.5666 76.1755 42.8944 76.5927 42.3952 77.3526C41.7396 78.5148 40.9499 77.8592 37.508 77.4793C34.0661 77.0993 36.2266 63.7266 48.9661 61.6778C50.5255 61.3696 52.1352 61.428 53.6682 61.8484C55.2012 62.2688 56.6155 63.0396 57.7996 64.1002C58.9836 65.1607 59.9051 66.4819 60.4911 67.9595C61.0772 69.4371 61.3119 71.0306 61.1767 72.6144C60.983 75.4305 59.2397 77.8294 58.152 79.2375C56.8184 80.9435 54.2705 84.3556 55.023 86.3895C56.1777 89.5036 58.517 88.9299 53.4808 92.5506C52.9512 93.0678 52.2794 93.4154 51.5513 93.5489ZM51.3725 92.2228C51.6183 92.5208 51.7524 92.3793 52.8178 91.6045C56.8482 88.6617 55.1645 90.1145 53.9502 86.7843C52.3484 82.4261 59.6941 77.6432 60.0368 72.5325C60.3199 68.2487 58.219 66.5278 58.3904 66.5278C56.2671 64.0395 54.1066 62.0578 49.1747 62.8028C37.5825 64.6578 36.1596 76.1308 37.6496 76.3022C42.8124 76.8758 40.9797 77.5612 41.8365 74.4397C42.8869 70.6029 44.7494 69.5748 46.3437 68.651C52.4825 65.0825 57.9136 70.2602 53.5628 75.5646C48.9885 81.167 46.7088 86.6428 51.3725 92.2228Z" fill="black"/>
            <path d="M59.9706 41.9509C60.9168 41.5113 64.4853 43.2174 58.4806 45.214C58.1259 45.3305 57.7437 45.3336 57.3872 45.2228C57.0307 45.1119 56.7176 44.8927 56.4915 44.5956C55.888 43.791 52.908 47.9556 50.4644 45.6014C48.8254 44.022 46.5681 47.8364 43.5806 47.5607C42.1949 47.4266 41.6138 47.1361 40.9657 47.4564C38.8573 48.5069 38.5891 48.9465 37.6132 48.8347C36.0114 48.5963 36.6223 47.1808 35.9295 47.4862C34.8772 47.9122 33.9125 48.5284 33.0836 49.304C32.9697 49.4299 32.821 49.5191 32.6563 49.5603C32.4917 49.6014 32.3185 49.5927 32.1588 49.5352C31.9991 49.4777 31.8601 49.3741 31.7595 49.2374C31.6588 49.1007 31.6011 48.9372 31.5936 48.7676C31.4967 47.8066 32.3386 47.2255 33.173 46.6146C34.7822 45.4673 37.1513 44.2976 38.0304 46.0558C38.1347 46.2495 38.0304 46.4134 39.3192 45.6237C40.9433 44.618 41.9789 45.0501 43.1634 45.0575C45.3612 45.0575 44.3331 45.281 47.3056 43.6421C48.8552 42.7853 50.4272 42.599 51.6862 43.8134C52.2971 44.4094 52.4312 44.0071 53.7126 43.2397C55.7018 42.0701 55.8284 41.8913 57.2663 42.2191C57.7133 42.3234 57.7654 42.9641 58.4732 42.6139C58.9872 42.3979 59.4789 42.1744 59.9706 41.9509Z" fill="black"/>
            <path d="M51.3436 35.9388C51.5075 36.0133 52.3568 36.0729 52.3419 36.8328C52.3419 37.8609 51.6416 38.1067 50.6805 38.4643C49.2576 39.0007 48.6765 38.5165 48.0656 38.6208C47.0449 38.7921 46.5756 39.0082 44.281 40.0437C43.923 40.162 43.5371 40.166 43.1767 40.0552C42.8163 39.9444 42.4992 39.7243 42.2695 39.4254C41.9193 38.6804 39.066 41.9882 37.1439 41.0197C35.7507 40.3194 35.937 39.5744 34.9983 39.9469C34.0596 40.3194 32.0704 41.3251 31.8469 42.1074C31.6234 42.8896 30.1558 42.6363 30.2899 41.638C30.3707 41.0921 30.586 40.5748 30.9163 40.1326C31.2466 39.6905 31.6816 39.3374 32.1822 39.105C34.1117 37.9503 35.7135 37.0339 37.5536 38.7102C37.6728 38.8219 37.7399 39.0082 37.9336 38.9784C38.9021 38.807 39.1479 38.1812 41.1073 37.2276C41.35 37.0887 41.6182 36.9999 41.8959 36.9666C42.1737 36.9333 42.4552 36.9562 42.7239 37.0339C43.238 37.0339 43.3274 37.2276 43.6775 37.5107C44.2363 37.9652 44.2735 37.1978 46.8885 36.4677C48.6765 35.976 48.6914 36.6763 49.9206 36.2815C50.3825 36.125 50.8072 35.7153 51.3436 35.9388Z" fill="black"/>
            <path d="M47.238 52.4032C47.983 52.2542 49.2271 52.515 48.9515 53.5356C48.8025 54.0944 48.8546 54.3402 48.3555 54.5116C46.1205 55.2566 45.8299 55.7185 44.3027 55.4578C43.9302 55.3982 43.6694 55.1896 43.2895 55.3237C40.8831 56.1804 40.2052 57.2011 38.9238 56.2847C38.1788 55.7334 38.6109 54.9139 38.0372 55.1076C37.0366 55.4761 36.0972 55.9935 35.2509 56.6423C35.1329 56.8055 34.9641 56.9249 34.7709 56.9817C34.5776 57.0386 34.371 57.0296 34.1835 56.9563C33.9959 56.883 33.838 56.7494 33.7345 56.5766C33.6311 56.4038 33.588 56.2016 33.6119 56.0016C33.6966 55.5147 33.9629 55.0781 34.3569 54.7798C36.0481 53.4835 39.259 51.8519 40.2052 53.7666C40.451 54.2657 40.3095 54.0273 41.9708 53.3345C42.6638 52.9946 43.451 52.8975 44.2058 53.0589C45.3382 53.4313 45.9268 52.6714 47.238 52.4032Z" fill="black"/>
            <path d="M29.8644 79.893C28.0392 67.9134 28.4788 70.208 28.1137 67.8911C26.9515 60.6497 27.1527 63.2423 26.8249 60.1431C26.1767 54.0862 26.0798 57.2152 25.6478 51.5532C25.3795 48.0517 24.575 46.7778 23.0626 34.6939C22.8317 32.8388 22.258 29.7024 23.5618 29.5683C23.9119 29.5683 26.4524 28.7711 27.8306 28.6147C29.2088 28.4582 47.4613 24.8897 51.9686 24.9567C53.1904 24.9567 52.9296 24.5619 61.7803 23.2581C83.1103 20.1068 83.0135 18.6466 84.6897 19.5331C85.0399 19.7119 90.1804 23.7275 91.5884 24.6885C96.9673 28.3688 97.0411 28.5774 97.6594 31.0657C97.7488 31.4382 97.7645 31.4531 98.137 31.5127C99.0682 31.6468 107.636 31.0136 107.651 31.0136C110.139 30.7826 110.287 31.5947 110.704 33.6658C111.293 36.528 111.571 39.4455 111.532 42.3674C111.532 42.7324 111.822 49.877 111.837 50.7933C111.837 51.583 111.718 51.5383 111.837 55.5762C111.837 56.6565 112.045 57.6101 112.008 58.5562C111.971 59.5024 121.038 69.7312 115.272 83.4839C113.782 86.9705 112.962 85.9499 115.033 87.3877C118.132 89.5482 118.014 89.5482 118.282 89.3992C119.727 88.6021 120.994 89.8164 122.141 90.5987C123.646 91.5345 125.081 92.5803 126.432 93.7277C136.408 101.349 141.622 103.606 143.351 105.327C145.914 107.875 142.032 113.433 138.933 113.522C135.834 113.612 133.904 109.052 116.62 97.5272C116.433 97.4005 115.719 96.7226 115.294 96.3799C114.646 95.8435 114.273 94.8899 114.444 94.5174C114.526 94.3386 114.526 94.3833 113.327 93.4669C113.103 93.303 113.081 93.8171 113.118 93.9363C113.401 94.8675 113.282 101.543 113.282 101.565C113.282 102.392 113.395 102.042 113.432 105.022C113.405 106.514 113.46 108.006 113.596 109.492C113.722 112.181 113.469 112.397 113.789 117.277C113.789 117.352 113.722 121.241 113.677 121.918C113.632 122.596 113.462 123.408 112.679 123.468C102.994 124.504 51.2616 126.776 45.0557 126.262C42.4706 126.046 42.6866 125.614 42.5227 123.2C42.3812 121.136 43.074 121.449 40.392 121.613C36.369 121.851 37.0172 122.097 36.4584 119.222C35.8997 116.346 36.0263 116.175 35.5793 113.478C33.2177 99.2183 34.3501 109.328 29.8652 79.893H29.8644ZM28.8811 72.6963C27.6667 65.0899 28.8811 72.6218 28.8811 72.6963V72.6963ZM142.636 108.725C142.887 108.163 142.936 107.532 142.774 106.938C142.612 106.345 142.25 105.826 141.749 105.469C131.036 98.5627 134.784 101.178 130.314 97.8773C118.557 89.1981 119.451 89.809 119.287 90.9265C119.075 91.7676 118.647 92.5384 118.043 93.1615C117.298 94.0853 116.673 95.0091 115.808 95.2028C115.063 95.3667 118.163 96.6928 131.811 107.294C138.933 112.815 138.285 112.807 141.004 110.96C141.674 110.315 142.226 109.558 142.636 108.725ZM116.329 93.5712C118.803 90.3603 118.654 90.8818 116.523 89.5184C115.912 89.1236 114.593 88.2892 113.647 87.7677C113.252 88.468 113.267 88.4158 113.267 88.5127C111.777 92.0812 111.428 90.852 112.851 91.8279C116.278 94.1523 115.875 94.1598 116.329 93.5712ZM114.154 82.7613C115.824 78.9927 116.357 74.819 115.688 70.7519C115.107 67.7719 114.028 63.8457 112.247 61.3798C100.461 45.0345 79.1983 47.2844 70.8551 62.0726C69.3557 64.8043 68.4184 67.8086 68.0986 70.9083C67.8825 72.0258 67.9868 72.7932 68.0539 75.8179C68.3519 90.107 84.5184 102.161 100.707 96.2309C101.629 95.9262 102.498 95.4815 103.284 94.9122C108.181 92.2121 112.014 87.9273 114.154 82.7613ZM112.515 121.889C112.65 120.503 112.061 96.2234 111.949 92.9678C111.949 92.2228 111.762 92.3047 111.308 91.9918C110.168 91.2468 110.094 91.0829 109.871 91.3288C108.567 92.7741 106.964 93.6681 107.017 94.0182C109.065 107.682 109.811 109.328 108.753 109.753C103.21 111.988 84.5102 114.722 80.0178 115.385C58.0254 118.633 59.6794 119.058 57.1017 119.192C54.3824 119.326 45.7851 121.077 45.7627 121.077C43.334 121.524 43.5277 121.196 43.5277 121.904C43.5277 122.611 43.5278 121.986 43.6097 124.608C43.6097 126.411 57.4071 124.846 62.7711 124.936L103.33 123.043C106.772 122.842 107.255 123.125 112.172 122.298C112.574 122.216 112.441 121.963 112.515 121.889ZM110.704 56.3287C110.168 29.6949 109.579 32.2652 107.501 32.2577C107.129 32.2246 106.755 32.2246 106.383 32.2577C104.595 32.5706 100.468 32.5036 98.3746 32.7569C97.9351 32.809 98.0915 32.8612 98.2703 34.1277C99.1048 39.8642 98.8887 38.8137 98.9706 39.4172C99.6709 44.7588 100.632 50.3389 100.647 50.4506C100.706 50.9349 100.968 50.8306 101.862 51.2403C102.854 51.6251 103.805 52.1093 104.7 52.6856C106.022 53.5009 107.269 54.4334 108.425 55.4719C109.118 56.135 109.103 55.8742 109.751 56.5745C109.997 56.8427 110.265 57.0886 110.496 57.3195C110.548 57.3642 110.63 57.3195 110.697 57.3791C110.719 57.02 110.722 56.6587 110.704 56.2989V56.3287ZM107.873 108.754C108.514 108.278 106.474 99.3897 105.937 94.9793C105.803 93.8171 103.448 97.8326 94.4932 98.8905C92.2527 99.0298 90.0036 98.9174 87.7882 98.5553C79.7124 96.5512 77.8357 94.7632 73.514 90.9712C65.9224 84.3109 65.0657 70.4837 69.7219 61.5288C75.0114 51.3446 88.63 46.6809 98.7769 50.0632C99.5741 50.3314 99.4258 50.2867 99.0682 48.2901C98.5318 45.3548 97.2057 34.1351 96.6544 31.7884C96.5352 31.2892 96.6023 31.8554 89.5248 34.0234C88.6174 34.3549 87.6653 34.5449 86.7005 34.5896C86.3135 34.6618 85.9136 34.6104 85.5575 34.4426C85.2014 34.2747 84.9072 33.999 84.7166 33.6546C84.5897 33.4261 84.5119 33.1736 84.4878 32.9133C84.46 30.888 84.3182 28.8659 84.0632 26.8565C83.7801 24.1447 83.833 20.4197 83.006 20.5985C82.3132 20.7549 67.592 23.6455 67.5771 23.6455C65.722 23.9659 68.7467 23.2507 56.0594 25.4335C46.9555 26.9906 46.5681 26.3722 37.9037 28.0038C23.1825 30.7752 23.8009 29.7098 23.8679 31.6692C24.1361 40.0132 26.1029 45.1984 26.8479 53.0432C27.0863 55.539 27.4365 55.5613 27.8015 59.1299C28.2113 63.0411 28.9712 65.3879 29.5597 69.8653C31.0497 81.3383 33.1432 95.62 36.6968 113.515C36.7415 113.731 37.196 117.553 37.4418 118.395C37.6877 119.236 37.7324 120.466 37.8143 120.533C38.0974 120.734 44.9514 120.071 46.3893 119.743C54.5992 117.895 104.759 111.071 107.873 108.725V108.754ZM95.6628 30.6783C97.6743 29.6577 92.5189 27.3109 86.2907 22.2971C84.3314 20.7251 84.4364 20.4867 84.6897 22.0661C84.8514 23.1021 84.9482 24.1471 84.9795 25.1951C85.3498 27.6633 85.5718 30.1509 85.6433 32.6451C85.6955 33.6881 87.3412 33.3901 88.3469 33.1443C89.7028 32.7792 95.5287 30.7156 95.6628 30.6783Z" fill="black"/>
            </svg>

                `;

            // Update the inner HTML of each list container
            listContainers.forEach(container => {
                container.innerHTML = newSVG;
            });

            // Clear the interval once all SVGs are updated
            if (listContainers.length > 0) {
                clearInterval(intervalId2);
            }
        }, 500); // Check every 500 milliseconds
    </script>

</x-filament-panels::page>
