<?php

namespace Adfox\Packages\Filament\Resources;

use Adfox\Packages\Filament\Resources\OrderPackageResource\Pages;
use Adfox\Packages\Filament\Resources\OrderPackageResource\RelationManagers;
use App\Filament\Clusters\PackageManagement;
use App\Models\OrderPackage;
use App\Models\OrderPackageItem;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\SelectColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Grouping\Group;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;


class OrderPackageResource extends Resource implements HasShieldPermissions
{
    protected static ?string $model = OrderPackageItem::class;

    protected static ?int $navigationSort = 2;

    protected static ?string $cluster = PackageManagement::class;

    protected static ?string $navigationIcon = 'heroicon-o-clipboard-document-list';

    public static function getPermissionPrefixes(): array
    {
        return [
            'view_any',
            'delete',
        ];
    }

    public static function canViewAny(): bool
    {
        return userHasPermission('view_any_order::package');
    }

    public static function canDelete($record): bool
    {
        return userHasPermission('delete_order::package');
    }

    public static function getModelLabel(): string
    {
        return __('messages.t_ap_order');
    }


    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->groups([
                Group::make('orderPackage.id')
                    ->label(__('messages.t_ap_order_id'))
                    ->getDescriptionFromRecordUsing(
                        function (OrderPackageItem $record): string {
                            return __('messages.t_ap_order_details', [
                                'user_name' => $record->orderPackage->user->name,
                                'user_id' => $record->orderPackage->user->id,
                                'payment_method' => ucfirst($record->orderPackage->payment_method),
                                'taxes' => $record->orderPackage->taxes_value,
                                'subtotal' => $record->orderPackage->subtotal_value,
                                'total' => $record->orderPackage->total_value,
                            ]);
                        }
                    )
            ])
            ->defaultGroup('orderPackage.id')
            ->modifyQueryUsing(fn (Builder $query) => $query)
            ->columns([
                TextColumn::make('name')
                    ->label(__('messages.t_ap_package_name')),

                TextColumn::make('activation_date')
                    ->label(__('messages.t_ap_activation_date'))
                    ->date(),

                TextColumn::make('expiry_date')
                    ->label(__('messages.t_ap_expiry_date'))
                    ->date(),

                TextColumn::make('price')
                    ->label(__('messages.t_ap_price')),

                TextColumn::make('purchased')
                    ->label(__('messages.t_ap_purchased')),

                TextColumn::make('available')
                    ->label(__('messages.t_ap_available')),

                TextColumn::make('used')
                    ->label(__('messages.t_ap_used')),

                TextColumn::make('orderPackage.created_at')
                    ->label(__('messages.t_ap_order_date'))
                    ->date(),

                SelectColumn::make('orderPackage.status')
                    ->label(__('messages.t_ap_status'))
                    ->options([
                        'completed' => __('messages.t_ap_status_completed'),
                        'pending' => __('messages.t_ap_status_pending'),
                        'failed' => __('messages.t_ap_status_failed'),
                        'refunded' => __('messages.t_ap_status_refunded'),
                    ]),
            ])
            ->filters([
            ])
            ->actions([
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
            ]);
    }


    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListOrderPackages::route('/'),
        ];
    }
}
