<?php

namespace Adfox\Packages\Livewire;

use Livewire\Attributes\On;
use Livewire\Component;
use App\Models\PackageItem;
use Carbon\Carbon;
use Livewire\Attributes\Reactive;

class Header extends Component
{
    public $selectedItems = [];
    public $totalPrice = 0;
    #[Reactive]
    public $current;

    public $pkg_type;

    /**
     * Toggle the selected items and recalculate total price.
     *
     * @param array $selectedItems Array of selected item IDs.
     */
    #[On('selected-package-items')]
    public function updateSelectedItems($selectedItems)
    {
        $this->selectedItems = $selectedItems;
        $this->calculateTotals();
    }

    /**
     * Calculate the total price of selected items.
     */
    private function calculateTotals()
    {
        $this->totalPrice = 0;
        $today = Carbon::today();

        foreach ($this->selectedItems as $itemId) {
            $item = PackageItem::find($itemId);
            if ($item) {
                $price = $item->offer_enabled && $item->offer_price
                         && $today->between($item->offer_start, $item->offer_end)
                         ? $item->offer_price : $item->price;

                $this->totalPrice += $price;
            }
        }
    }

    /**
     * Advance to the next step.
     */
    public function next()
    {
        $this->dispatch('proceed-next');
    }

    /**
     * Apply Package.
     */
    public function apply()
    {
        $this->dispatch('apply-package');
    }

    /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public function render()
    {
        return view('packages::header');
    }
}
