<?php

namespace Adfox\Paymongo\Filament\Pages;
use App\Settings\PayMongoSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Illuminate\Support\Facades\Config;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class ManagePaymongo extends SettingsPage
{
    use HasPageShield;


    protected static ?string $slug = 'manage-paymongo-settings';

    protected static string $settings = PayMongoSettings::class;

    protected static ?int $navigationSort = 20;

    public static function getNavigationBadgeTooltip(): ?string
    {
        return 'PayMongo Payment Module (Addon) - Accept payments via PayMongo gateway, popular in Philippines. Requires separate purchase.';
    }

    public static function getNavigationBadge(): ?string
    {
        $isDemo = Config::get('app.demo');
        return  $isDemo  ? 'Addon' : '';
    }

    public static function getNavigationBadgeColor(): ?string
    {
        return 'danger';
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_ManagePaymongo');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_paymongo_settings');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_payment_gateways');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_paymongo_settings');
    }
    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(PayMongoSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            // Check if the property exists in the GeneralSettings class
            if (property_exists($previousData, $key)) {
                // Get the type of the property
                $propertyType = gettype($previousData->$key);

                // If the item is null and the property type is string, set it to an empty string
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            // For other cases, just copy the item as is
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $currenciesConfig = config('money.currencies');
        $currencyCodes = array_keys($currenciesConfig);
        $isDemo = Config::get('app.demo');

        return $form
            ->schema([
                TextInput::make('name')
                ->label(__('messages.t_ap_paymongo_name_label'))
                ->required()
                ->helperText(__('messages.t_ap_paymongo_name_helper_text')),

            Toggle::make('status')
                ->label(__('messages.t_ap_enable_paymongo_label'))
                ->helperText(__('messages.t_ap_enable_paymongo_helper_text')),

            Select::make('currency')
                ->label(__('messages.t_ap_default_currency_label'))
                ->options(array_combine($currencyCodes, $currencyCodes))
                ->required()
                ->helperText(__('messages.t_ap_default_currency_helper_text')),

            $isDemo ?
                TextInput::make('public_key')
                    ->label(__('messages.t_ap_paymongo_public_key_label'))
                    ->placeholder(__('messages.t_ap_placeholder_hidden'))
                    ->disabled()
                    ->helperText(__('messages.t_ap_paymongo_public_key_demo_helper_text')) :
                TextInput::make('public_key')
                    ->label(__('messages.t_ap_paymongo_public_key_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_paymongo_public_key_helper_text')),

            $isDemo ?
                TextInput::make('secret_key')
                    ->label(__('messages.t_ap_paymongo_secret_key_label'))
                    ->placeholder(__('messages.t_ap_placeholder_hidden'))
                    ->disabled()
                    ->helperText(__('messages.t_ap_paymongo_secret_key_demo_helper_text')) :
                TextInput::make('secret_key')
                    ->label(__('messages.t_ap_paymongo_secret_key_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_paymongo_secret_key_helper_text')),

            $isDemo ?
                TextInput::make('authorization_token')
                    ->label(__('messages.t_ap_paymongo_authorization_token_label'))
                    ->placeholder(__('messages.t_ap_placeholder_hidden'))
                    ->disabled()
                    ->helperText(__('messages.t_ap_paymongo_authorization_token_demo_helper_text')) :
                TextInput::make('authorization_token')
                    ->label(__('messages.t_ap_paymongo_authorization_token_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_paymongo_authorization_token_helper_text')),

            ])
            ->columns(2);
    }
}
