<?php

namespace Adfox\Paypal\Providers;

use Adfox\Paypal\Livewire\PaypalPayment;
use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Adfox\Paypal\PaypalPlugin;
use Livewire\Livewire;

class PaypalServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new PaypalPlugin()));
    }

    public function boot()
    {
        Relation::morphMap([]);
        Livewire::component('paypal-payment', PaypalPayment::class);
    }

}
