<?php
namespace Adfox\Paystack\Filament\Pages;

use App\Settings\PaystackSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use App\Models\SettingsProperty;
use Filament\Forms\Components\Placeholder;
use Illuminate\Support\Facades\Config;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class PaystackPayment extends SettingsPage
{
    use HasPageShield;

    protected static ?string $slug = 'manage-paystack-settings';

    protected static string $settings = PaystackSettings::class;

    protected static ?int $navigationSort = 21; // Adjust the sort order as needed


    public static function getNavigationBadgeTooltip(): ?string
    {
        return 'Paystack Payment Module (Addon) - Process payments through Paystack gateway, popular in Africa. Requires separate purchase.';
    }

    public static function getNavigationBadge(): ?string
    {
        $isDemo = Config::get('app.demo');
        return  $isDemo  ? 'Addon' : '';
    }

    public static function getNavigationBadgeColor(): ?string
    {
        return 'danger';
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_PaystackPayment');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_paystack_settings');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_payment_gateways');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_paystack_settings');
    }
    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(PaystackSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);

                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $paystackCurrencies = [
            'NGN' => __('messages.t_ap_ngn_currency_name'),
            'USD' => __('messages.t_ap_usd_currency_name'),
            'GHS' => __('messages.t_ap_ghs_currency_name'),
            'ZAR' => __('messages.t_ap_zar_currency_name'),
            'KES' => __('messages.t_ap_kes_currency_name')
        ];

        $isDemo = Config::get('app.demo');

        return $form
            ->schema([
                TextInput::make('name')
                    ->label(__('messages.t_ap_paystack_name_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_paystack_name_helper_text')),

                Toggle::make('status')
                    ->label(__('messages.t_ap_enable_paystack_label'))
                    ->helperText(__('messages.t_ap_enable_paystack_helper_text')),

                Select::make('currency')
                    ->label(__('messages.t_ap_default_currency_label'))
                    ->options($paystackCurrencies)
                    ->required()
                    ->helperText(__('messages.t_ap_default_currency_helper_text')),

                $isDemo ?
                Placeholder::make('public_key')
                    ->label(__('messages.t_ap_paystack_public_key_label'))
                    ->content(__('messages.t_ap_placeholder_hidden'))
                    ->hint(__('messages.t_ap_placeholder_hidden_hint')) :
                TextInput::make('public_key')
                    ->label(__('messages.t_ap_paystack_public_key_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_paystack_public_key_helper_text')),

                $isDemo ?
                Placeholder::make('secret_key')
                    ->label(__('messages.t_ap_paystack_secret_key_label'))
                    ->content(__('messages.t_ap_placeholder_hidden'))
                    ->hint(__('messages.t_ap_placeholder_hidden_hint')) :
                TextInput::make('secret_key')
                    ->label(__('messages.t_ap_paystack_secret_key_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_paystack_secret_key_helper_text')),

                TextInput::make('exchange_rate')
                    ->label(__('messages.t_ap_exchange_rate_label'))
                    ->numeric()
                    ->required()
                    ->helperText(__('messages.t_ap_exchange_rate_helper_text')),
            ])
            ->columns(2);
    }
}
