<?php

namespace Adfox\Subscription\Livewire\PaymentMethods;

use App\Models\Plan;
use App\Settings\StripeSettings;
use Carbon\Carbon;
use Livewire\Component;
use Filament\Notifications\Notification;
use Livewire\Attributes\Reactive;
use Stripe\StripeClient;

class StripeSubscription extends Component
{
    public $id;

    public $total;

    public $tax;

    public $type;

    public $data;

    public $subtotal;
    public $priceId;
    public $planId;

    public $clientSecretKey;

    public $payment_gateway_params = [];
    public $customerId;
    #[Reactive]
    public $stripe_coupon_id;

    /**
     * Mount the component and set the properties if an ad ID is provided.
     */
    public function mount()
    {
        if (isset($this->data['plan_id'])) {
        }
        if (isset($this->data['plan_id'])) {
            $this->planId = $this->data['plan_id'];
            $this->updatePriceData();
        }
        $this->processPayment();
        $this->dispatch('initialize-stripe-form');
    }

    /**
     * Update the price data for the given product ID.
     *
     * @param int $productId The Stripe product ID.
     *
     * @return \Illuminate\Http\JsonResponse
     *
     * @throws \Stripe\Exception\CardException
     * @throws \Exception
     */
    public function updatePriceData(){
        $plan=Plan::find($this->planId);
        try {
            $stripe = $this->initializeStripeClient();
            //Create price
            $price = $stripe->prices->create([
                'product' => $plan->stripe_product_id,
                'unit_amount' => (int) $this->subtotal* 100,
                'currency' => $this->stripePaymentSettings?->currency,
                'recurring' => [
                    'interval' => $plan->invoice_interval,
                    'interval_count' => $plan->invoice_period
                ],
            ]);
            $this->priceId= $price->id;
        } catch (\Stripe\Exception\CardException $e) {
            Notification::make()
                ->title($e->getError()->message)
                ->send();
            return response()->json(['error' => $e->getError()->message], 500);
        } catch (\Exception $e) {
            Notification::make()
            ->title(__('messages.t_common_error'))
            ->body($e->getMessage())
            ->danger()
            ->send();
        }
    }

    public function getStripePaymentSettingsProperty()
    {
        return app(StripeSettings::class);
    }
    public function processPayment()
    {
        // $subscription = Subscription::create([
        //     'subscriber_type' => 'App\\Models\\User',      // example subscriber type
        //     'subscriber_id' => '123e4567-e89b-12d3-a456-426614174000', // example UUID
        //     'plan_id' => 1,                                // example plan id
        //     'subscription_reference' => 'SUB-20241001',    // unique reference
        //     'payment_method' => 'credit_card',
        //     'status' => 'active',
        //     'trial_ends_at' => Carbon::parse('2024-10-15 00:00:00'),
        //     'starts_at' => Carbon::parse('2024-10-01 00:00:00'),
        //     'ends_at' => Carbon::parse('2025-10-01 00:00:00'),
        //     'cancels_at' => null,                          // set to null if not applicable
        //     'paused_at' => null,                           // set to null if not applicable
        //     'gateway_data' => json_encode(['transaction_id' => 'TX123456']),
        //     'metadata' => json_encode(['notes' => 'First-time subscriber']),
        //     'created_at' => Carbon::now(),
        //     'updated_at' => Carbon::now(),
        // ]);
    //   $Invoice =  Invoice::create([
    //         'subscription_id' => 1,
    //         'invoice_id' => 'INV-2024122',
    //         'currency' => 'USD',
    //         'status' => 'unpaid',
    //         'amount_due' => 5000,
    //         'amount_paid' => 0,
    //         'amount_remaining' => 5000,
    //         'invoice_date' => Carbon::parse('2024-10-01 08:30:00'),
    //         'due_date' => Carbon::parse('2024-11-01 08:30:00'),
    //         'created_at' => Carbon::now(),
    //         'updated_at' => Carbon::now(),
    //     ]);

        try {
            $stripe = new \Stripe\StripeClient($this->stripePaymentSettings?->secret_key);
            $user = auth()->user();
            $customer = $stripe->customers->create([
                    'email' => $user->email,
                    'name' => $user->name,
                ]);
            $this->customerId = $customer ? $customer->id : null;
            // Create the subscription with the customer ID, price ID, and necessary options.
            // $subscription = $stripe->subscriptions->create([
            //     'customer' => $customer->id,
            //     'items' => [
            //         [
            //             'price' => $this->priceId,
            //             // For metered billing, do not pass quantity
            //             'quantity' => 1,
            //         ]
            //     ],
            //     'payment_behavior' => 'default_incomplete',
            //     'payment_settings' => ['save_default_payment_method' => 'on_subscription'
            //     ],
            //     'expand' => ['latest_invoice.payment_intent'],
            //     'metadata' => [
            //             'user_id' => auth()->id(),
            //             'plan_id' => $this->planId
            //         ]
            // ]);

            // $this->clientSecretKey = $subscription->latest_invoice->payment_intent->client_secret;
        } catch (\Throwable $throwable) {
            Notification::make()
                ->title(__('messages.t_error_payment_failed'))
                ->danger()
                ->body($throwable->getMessage())
                ->send();
        }
    }
    public function initializeStripeClient()
    {
        // Set Stripe API key
        return new StripeClient($this->stripePaymentSettings?->secret_key);
    }
    /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public function render()
    {
        return view('subscription::payment-methods.stripe-subscription');
    }

}
