<?php
namespace Adfox\Subscription\Livewire\Promotion;

use App\Models\Ad;
use App\Models\Promotion;
use App\Settings\GeneralSettings;
use App\Settings\SEOSettings;
use Artesaos\SEOTools\Traits\SEOTools;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Illuminate\Support\Facades\Session as FacadesSession;
use Livewire\Attributes\On;
use Livewire\Attributes\Reactive;
use Livewire\Attributes\Session;
use Livewire\Component;
use Filament\Forms\Form;
use Filament\Forms\Components\TextInput;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\Url;

class PromotionDetails extends Component implements HasForms
{
    use InteractsWithForms,SEOTools;

    public $selectedAdSlugs;
    public $selectedAds=[];

    public $id;
    #[Reactive]
    public $availablePlanPromotions;
    #[Url(as: 'promotion_type', keep: true)]
    public $promotionType;

    #[Reactive]
    public $selectedPromotions;
    public $promotions = [];

    public $website_url;
    public $website_label;
    public function mount()
    {
        //if promotion type is multiple load promotions data
        if ($this->promotionType == 'multiple') {
            $this->loadPromotions();
        }

        //if promotion type is apply load ad details
        if ($this->promotionType == 'apply') {
            $this->loadAdDetails($this->id);
        }
        $this->setSeoData();
    }
    /**
     * Fetch the promotions data
     *
     * @return void
     */
    public function loadPromotions()
    {
        $this->promotions = Promotion::all();
    }

       /**
     * Calculate the remaining ad promotion count for promotion
     *
     * @param [type] $promotionId
     * @return void $adPromotionCount
     */
    public function getRemainAdPromotionCount($promotionId)
    {
        $activeSubscription=getActiveSubscription();
        $adPromotionCount=0;

        if($promotionId==1){
            $adPromotionCount = getRemaningFeaturedAdCount();
        }
        if($promotionId==2){
            $adPromotionCount = getRemaningSpotlightAdCount();
        }
        if($promotionId==3){
            $adPromotionCount = getRemaningUrgentAdCount();
        }
        if($promotionId==4){
            $adPromotionCount = getRemaningWebsiteUrlAdCount();
        }
        return $adPromotionCount;
    }

    /**
     * Update the website url
     *
     * @param [type] $value
     * @return void
     */
    public function updatedWebsiteUrl($value)
    {
        //if user multiple selected ad then update url to all selected ad
        if ($this->selectedAdSlugs &&count($this->selectedAdSlugs)) {
            $ads = Ad::whereIn('slug', $this->selectedAdSlugs)->update(['website_url' => $value]);
        }
        //if user selected the single ad then update url to selected ad
        if ($this->id) {
            $ad = Ad::find($this->id);
            if ($ad) {
                $ad->update(['website_url' => $value]);
            }
        }
    }

      /**
     * Update the website label
     *
     * @param [type] $value
     * @return void
     */
    public function updatedWebsiteLabel($value)
    {
        //if user multiple selected ad then update label to all selected ad
        if ($this->selectedAdSlugs && count($this->selectedAdSlugs)) {
            $ads = Ad::whereIn('slug', $this->selectedAdSlugs)->update(['website_label' => $value]);
        }
        //if user selected the single ad then update label to selected ad
        if ($this->id) {
            $ad = Ad::find($this->id);
            if ($ad) {
                $ad->update(['website_label' => $value]);
            }
        }
    }

    #[On('validate-fields')]
    public function validatingFields()
    {
        $this->validate();
        $this->dispatch('apply-promotion');
    }
    /**
     * Define the form for the website URL input.
     *
     * @param Form $form
     * @return Form
     */
    public function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('website_url')
                    ->label(__('messages.t_website_url'))
                    ->live(onBlur: true)
                    ->placeholder(__('messages.t_enter_your_business_website'))
                    ->minLength(10)
                    ->required(in_array(4, $this->selectedPromotions)),

                TextInput::make('website_label')
                    ->label(__('messages.t_website_label'))
                    ->live(onBlur: true)
                    ->placeholder(__('messages.t_enter_website_label'))
                    ->minLength(2)
                    ->required(in_array(4, $this->selectedPromotions)),
            ]);
    }

    /**
     * Load and set ad details if an ID is provided.
     *
     * @param int $id The ID of the ad to load
     */
    private function loadAdDetails($id)
    {
        $ad = Ad::find($id);
        if ($ad) {
            $this->website_url = $ad->website_url;
            $this->website_label = $ad->website_label;
        }
    }

        /**
    * Set SEO data
    */
    protected function setSeoData()
    {
        $generalSettings = app(GeneralSettings::class);
        $seoSettings = app(SEOSettings::class);


        $separator = $generalSettings->separator ?? '-';
        $siteName = $generalSettings->site_name ?? app_name();

        $title = __('messages.t_choose_plan') . " $separator " . $siteName;
        $description = $seoSettings->meta_description;
        $this->seo()->setTitle($title);
        $this->seo()->setDescription($description);
    }
    public function render()
    {
        return view('subscription::promotion.promotion-details');
    }
}
