<?php

namespace Adfox\Subscription\Livewire;

use App\Models\Ad;
use App\Settings\GeneralSettings;
use App\Settings\SEOSettings;
use Livewire\Attributes\Url;
use Livewire\Component;
use Artesaos\SEOTools\Traits\SEOTools as SEOToolsTrait;

class SubscriptionSuccess extends Component
{
    use SEOToolsTrait;

    #[Url(as:'payment_intent')]
    public $paymentIntent;

    #[Url(as:'payment_intent_client_secret')]
    public $paymentIntentClientSecret;
    public $isMobileHidden = false;

    public function mount()
    {
        $this->setSeoData();
        abortIfSubscriptionDisabled();
    }

     /**
    * Set SEO data
    */
    protected function setSeoData()
    {
        $generalSettings = app(GeneralSettings::class);
        $seoSettings = app(SEOSettings::class);


        $separator = $generalSettings->separator ?? '-';
        $siteName = $generalSettings->site_name ?? app_name();

        $title = __('messages.t_general_success') . " $separator " . $siteName;
        $description = $seoSettings->meta_description;

        $this->seo()->setTitle($title);
        $this->seo()->setDescription($description);
    }


    /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public function render()
    {
        return view('subscription::subscription-success');
    }
}
