<?php

namespace Adfox\Subscription\Notifications;

use Filament\Notifications\Actions\Action;
use Filament\Notifications\Notification as FilamentNotification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PaymentFailedNotification extends Notification
{
    use Queueable;

    public $invoice;
    /**
     * Create a new notification instance.
     */
    public function __construct($invoice)
    {
        $this->invoice = $invoice;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
        ->subject(trans('messages.t_et_payment_failed_subject'))
        ->line(trans('messages.t_et_payment_failed_body'))
        ->line(trans('messages.t_et_payment_failed_invoice', ['invoiceId' => $this->invoice->id]))
        ->line(trans('messages.t_et_payment_failed_amount', ['amount' => number_format($this->invoice->amount_due / 100, 2)]))
        ->line(trans('messages.t_et_thank_you_message'));    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toDatabase(object $notifiable): array
    {
        $notificationTitle = trans('messages.t_et_payment_failed_subject');
        $notificationBody = trans('messages.t_et_payment_failed_invoice', ['invoiceId' => $this->invoice->id]) . PHP_EOL . trans('messages.t_et_payment_failed_amount', ['amount' => number_format($this->invoice->amount_due / 100, 2)]);

        return FilamentNotification::make()
            ->success()
            ->title($notificationTitle)
            ->body($notificationBody)
            ->getDatabaseMessage();
    }
}
