<?php

namespace Adfox\Subscription\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Filament\Notifications\Notification as FilamentNotification;

class SubscriptionCreatedNotification extends Notification
{
    use Queueable;

    public $subscription;
    /**
     * Create a new notification instance.
     */
    public function __construct($subscription)
    {
       $this->subscription = $subscription;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
        ->subject(trans('messages.t_et_subscription_activated_subject'))
        ->line(trans('messages.t_et_subscription_activated_body', ['subscriptionId' => $this->subscription->id]))
        ->action(trans('messages.t_et_my_subscriptions'), route('filament.app.pages.my-subscriptions'))
        ->line(trans('messages.t_et_thank_you_message'));    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toDatabase(object $notifiable): array
    {
        $notificationTitle = trans('messages.t_et_subscription_activated_subject');
        $notificationBody = trans('messages.t_et_subscription_activated_body', ['subscriptionId' => $this->subscription->id]);

        return FilamentNotification::make()
            ->success()
            ->title($notificationTitle)
            ->body($notificationBody)
            ->getDatabaseMessage();
    }
}
