<?php

namespace Adfox\WalletSystem\Filament\Pages;

use Adfox\PointVault\Filament\Pages\PointVaultConfiguration;
use App\Settings\PointVaultSettings;
use Adfox\WalletSystem\Settings\WalletSystemSetting;
use App\Filament\Clusters\WalletSystem;
use Filament\Forms\Components\Fieldset;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Pages\SettingsPage;
use Symfony\Component\Console\Input\Input;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class ManageWalletSystem extends SettingsPage
{
    use HasPageShield;

    protected static string $settings = WalletSystemSetting::class;
    protected static ?string $slug = 'manage-wallet-commission';

    protected static ?string $cluster = WalletSystem::class;

    protected static ?string $navigationIcon = 'heroicon-o-adjustments-horizontal';

    public static function canAccess(): bool
    {
        return userHasPermission('page_ManageWalletSystem');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_wallet_commission');
    }

    public function getTitle(): string
    {
        return __('messages.t_wallet_commission');
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(WalletSystemSetting::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }

        return $filtered;
    }

    // public function afterSave()
    // {
    //     //Enable wallet if Point enabled

    //     if (isPointSystemPluginEnabled()) {
    //         $pointVaultSetting = app(PointVaultSettings::class);
    //         $pointVaultSetting->enable_point_system = $this->data['enable_wallet_system'];
    //         $pointVaultSetting->save();
    //     }
    // }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('enable_wallet_system')
                    ->label(__('messages.t_enable_wallet_system'))
                    ->live(onBlur: true)
                    ->helperText(__('messages.t_enable_wallet_system_helperText')),
                TextInput::make('delivery_confirmation_time')
                    ->label(__('messages.t_ad_delivery_conf_time'))
                    ->numeric()
                    ->minValue(1)
                    ->required()
                    ->helperText(__('messages.t_ad_delivery_conf_time_helper')),
                Fieldset::make()->schema([
                    Toggle::make('enable_commission')
                        ->label(__('messages.t_enable_commission'))
                        ->helperText(__('messages.t_enable_commission_helperText')),
                    TextInput::make('commission_value')
                        ->label(__('messages.t_commission_value'))
                        ->helperText(__('messages.t_commission_value_helperText')),
                    Select::make('commission_type')
                        ->options([
                            'fixed' => 'Fixed',
                            'percentage' => 'Percentage'
                        ])
                        ->label(__('messages.t_commission_type'))
                        ->helperText(__('messages.t_commission_type_helperText')),
                ])->visible(function (Get $get) {
                    return $get('enable_wallet_system');
                })
            ])
            ->columns(2);
    }
}
