<?php

namespace Adfox\WalletSystem\Filament\Resources;

use Adfox\WalletSystem\Filament\Resources\WalletClaimResource\Pages;
use App\Models\Wallets\WalletTransaction;
use Adfox\WalletSystem\Traits\WalletHelper;
use App\Filament\Clusters\WalletSystem;
use Filament\Forms\Components\Fieldset;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables\Actions\Action;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;
use Filament\Tables;


class WalletClaimResource extends Resource implements HasShieldPermissions
{
    use WalletHelper;

    protected static ?string $model = WalletTransaction::class;

    protected static ?string $cluster = WalletSystem::class;

    protected static ?string $navigationIcon = 'heroicon-o-paper-airplane';

    public static function getNavigationLabel(): string
    {
        return __('messages.t_wallet_claim_request_label');
    }

    public static function getModelLabel(): string
    {
        return __('messages.t_wallet_claim_request_label');
    }

    public static function getPermissionPrefixes(): array
    {
        return [
            'view_any',
            'delete_any'
        ];
    }

    public static function canViewAny(): bool
    {
        return userHasPermission('view_any_wallet::claim');
    }

    public static function canDeleteAny(): bool
    {
        return userHasPermission('delete_any_wallet::claim');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->modifyQueryUsing(fn(Builder $query) => $query->where('transaction_type', 'claim_request')->latest())
            ->columns([
                TextColumn::make('user.name'),
                ...self::initializeWalletTransactionTableColumns(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Action::make('Make as Paid')->form([
                    Fieldset::make('Bank Details')->schema([
                        TextInput::make('bank_name')
                            ->default(function ($record) {
                                return $record->bank_details['bank_name'];
                            })  // Set your default value here
                            ->disabled(),  // Set field as read-only

                        TextInput::make('account_number')
                            ->default(function ($record) {
                                return $record->bank_details['account_number'];
                            })  // Set your default value here
                            ->disabled(),  // Set field as read-only

                        TextInput::make('ifsc_code')
                            ->default(function ($record) {
                                return $record->bank_details['ifsc_code'];
                            })  // Set your default value here
                            ->disabled(),  // Set field as read-only

                        TextInput::make('account_holder_name')
                            ->default(function ($record) {
                                return $record->bank_details['account_holder_name'];
                            })  // Set your default value here
                            ->disabled(),  // Set field as read-only
                    ]),
                    TextInput::make('transaction_reference')->required()
                ])->action(function ($record, $data) {
                    $data['status'] = 'completed';
                    $record->update($data);
                })->hidden(fn($record) => $record->status === 'completed'),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListWalletClaims::route('/'),
            // 'create' => Pages\CreateWalletClaim::route('/create'),
            // 'edit' => Pages\EditWalletClaim::route('/{record}/edit'),
        ];
    }
}
