<?php

namespace Adfox\WalletSystem\Traits;

use App\Models\Wallets\Wallet;;

use Carbon\Carbon;
use Exception;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

trait WalletHelper
{
    private static function initializeWalletTransactionTableColumns()
    {
        $totalWallet = Wallet::where('user_id', auth()->id())->first();

        return [
            TextColumn::make('created_at')
                ->label(__('messages.t_wallet_table.date'))
                ->sortable()
                ->formatStateUsing(fn($state) => Carbon::parse($state)->format('d M Y h:m a'))
                ->searchable(),
            TextColumn::make('points')
                ->label(__('messages.t_ap_points',['short_name' => getPointSystemSetting('short_name')]))
                ->formatStateUsing(fn($state) => $state . ' ' . getPointSystemSetting('short_name'))
                ->sortable()
                ->searchable()
                ->badge()
                ->visible(fn() => isEnablePointSystem())
                ->color(fn($record) => $record->is_added ? 'success' : 'danger'),
                // ->visible(max($totalWallet?->points, 0) > 1),
            TextColumn::make('amount')
                ->label(__('messages.t_wallet_table.amount'))
                ->sortable()
                ->searchable()
                ->hidden(fn() => isEnablePointSystem())
                ,
                // ->visible(max($totalWallet?->balance, 0) > 1),
            TextColumn::make('payable_type')
                ->label(__('messages.t_earning_table.payable_type'))
                ->formatStateUsing(fn($state) => __('messages.t_'.strtolower(class_basename($state))))
                ->sortable(),
            TextColumn::make('transaction_type')
                ->badge()
                ->colors([
                    'primary',
                    'success' => 'deposit',
                    'info' => 'claim_request',
                    'danger'  => 'failed',
                ])
                ->formatStateUsing(fn($state) => str_replace('_', ' ', Str::title($state))) // Translate the status
                ->label(__('messages.t_wallet_table.transaction_type'))
                ->sortable()
                ->searchable(),

            TextColumn::make('transaction_reference')
                ->default('-')
                ->label(__('messages.t_wallet_table.transaction_reference'))
                ->sortable()
                ->searchable(),

            TextColumn::make('status')
                ->label(__('messages.t_wallet_table.status'))
                ->colors([
                    'primary',
                    'success' => 'completed',
                    'info' => 'request',
                    'warning' => 'pending',
                    'danger'  => 'failed',
                ])
                ->formatStateUsing(fn($state) => __("messages.t_wallet_status_$state")) // Translate the status
                ->sortable()
                ->searchable(),
        ];
    }
}
