<div x-data="{ state: $wire.$entangle('data.selected_theme'),showModal:false,url:'' }">
    <label class="text-sm font-medium leading-6 text-gray-950 dark:text-white">{{ __('messages.t_ap_theme') }}</label>
    <div class=" grid grid-cols-1 sm:grid-cols-2 2xl:grid-cols-4 gap-2 w-full sm:w-fit 2xl:w-full">

        <!-- Classic Theme -->
        <div  class="relative border-black rounded-md p-2 2xl:cols-span-1 w-full sm:w-[300px] 2xl:w-full">
            <div @click="state='classic'" class="mx-2 " x-bind:class="state == 'classic' ? 'font-bold  ' : ''">
                <div class="flex items-center mb-4">
                    <input id="classic" type="radio" x-model="state" value="classic" name="default-radio"
                        class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                    <label for="classic"
                        class="ms-2 text-sm cursor-pointer text-gray-900 dark:text-gray-300">{{ __('messages.t_ap_classic') }}</label>
                    </div>
                    <img src="{{ asset('images/classic-theme.png') }}" alt="" >
            </div>
            <!-- Expand button -->
            <button type="button" aria-label="{{__('messages.t_aria_label_expand')}}" x-on:click="url='{{ asset('images/classic-theme-full.png') }}';showModal = true;" class="absolute top-2 right-2 mr-2 cursor-pointer"
            x-tooltip="{
                content: '{{__('messages.t_tooltip_expand')}}',
                theme: $store.theme,
            }" >
                <x-heroicon-o-arrows-pointing-out class=" w-7 h-7  text-black dark:text-gray-400" />
            </button>
        </div>

        <!-- Modern Theme -->
        <div class="relative border-black rounded-md p-2 2xl:cols-span-1 w-full sm:w-[300px] 2xl:w-full">
            <div @click="state='modern'" class="mx-2" x-bind:class="state == 'modern' ? 'font-bold  ' : ''">
                <div class="flex items-center mb-4">
                    <input id="modern" type="radio" value="modern" x-model="state" name="default-radio"
                        class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                    <label for="modern"
                        class="ms-2 text-sm cursor-pointer text-gray-900 dark:text-gray-300">{{ __('messages.t_ap_modern') }}</label>
                    </div>
                    <img src="{{ asset('images/modern-theme.png') }}" alt="" >
            </div>
            <!-- Expand button -->
            <button type="button" aria-label="{{__('messages.t_aria_label_expand')}}" x-on:click="url='{{ asset('images/modern-theme-full.png') }}';showModal = true;" class="absolute top-2 right-2 mr-2 cursor-pointer"
            x-tooltip="{
                content: '{{__('messages.t_tooltip_expand')}}',
                theme: $store.theme,
            }" >
                <x-heroicon-o-arrows-pointing-out class=" w-7 h-7  text-black dark:text-gray-400" />
            </button>
        </div>
    </div>

    <!-- Full image modal -->
    <div x-show="showModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 flex justify-center items-center" x-cloak>
        <div class="relative mx-auto rounded-md">
            <div class="p-10 overflow-auto max-h-[90vh]" x-ref="fullImage"  >
                <img :src="url" alt="" class="w-full  rounded-md" x-init="$refs.fullImage.scrollTop=0" @mouseover="$refs.fullImage.scrollTop=0">
            </div>
            <!-- Close Button -->
            <button type="button" aria-label="{{__('messages.t_aria_label_close')}}" @click="showModal = false" class="fixed flex items-center justify-center top-0 right-0 mt-2 mr-2 w-10 h-10 text-white bg-black bg-opacity-50 rounded-full"
            x-tooltip="{
                content: '{{__('messages.t_tooltip_close')}}',
                theme: $store.theme,
            }">
                <x-heroicon-o-x-mark class="w-6 h-6" />
            </button>
        </div>
    </div>
</div>
