<?php

namespace Adfox\Appearance\Filament\Pages;

use App\Filament\Clusters\DesignAppearance;
use App\Settings\BannerSettings;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Pages\SettingsPage;
use Illuminate\Contracts\Support\Htmlable;

class ManageBanner extends SettingsPage
{

    protected static string $settings = BannerSettings::class;

    public ?array $data = [];

    protected static ?string $cluster = DesignAppearance::class;

    protected static ?string $navigationIcon = 'heroicon-o-squares-plus';

    public function getTitle(): string|Htmlable
    {
        return __('messages.t_ap_banner_settings');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_banner_settings');
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_ManageBanner');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('enable_carousel')
                    ->label(__('messages.t_ap_enable_carousel'))
                    ->helperText(__('messages.t_ap_enable_carousel_helper'))
                    ->columnSpanFull(),

                Toggle::make('enable_pagination_count')
                    ->label(__('messages.t_ap_enable_pagination_count'))
                    ->helperText(__('messages.t_ap_enable_pagination_count_helper')),

                Toggle::make('enable_autoplay')
                    ->label(__('messages.t_ap_enable_autoplay'))
                    ->helperText(__('messages.t_ap_enable_autoplay_helper'))
                    ->live(),

                TextInput::make('autoplay_interval')
                    ->required()
                    ->visible(fn(Get $get) => $get('enable_autoplay'))
                    ->numeric()
                    ->minValue(0.1)
                    ->label(__('messages.t_ap_autoplay_interval'))
                    ->helperText(__('messages.t_ap_autoplay_interval_helper')),

            ])
            ->statePath('data');
    }
}
