<?php

namespace Adfox\Blog\Filament\Resources\PostResource\Pages;

use Adfox\Blog\Filament\Resources\PostResource;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Infolists\Components\IconEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Infolist;
use Filament\Resources\Pages\ManageRelatedRecords;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Contracts\Support\Htmlable;

class ManagePostComments extends ManageRelatedRecords
{
    protected static string $resource = PostResource::class;

    protected static string $relationship = 'comments';

    protected static ?string $modelLabel = 'comment';

    protected static ?string $navigationIcon = 'heroicon-o-chat-bubble-left-ellipsis';

    public static function getModelLabel(): string
    {
        return __('messages.t_ap_comment');
    }

    public function getTitle(): string|Htmlable
    {
        return __('messages.t_ap_manage_comments', ['record' => $this->getRecordTitle()]);
    }

    public function getBreadcrumb(): string
    {
        return __('messages.t_ap_comments');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_manage_comments_navigation');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->required()
                    ->label(__('messages.t_ap_name')),

                Forms\Components\TextInput::make('email')
                    ->required()
                    ->label(__('messages.t_ap_email')),

                Forms\Components\MarkdownEditor::make('comment')
                    ->required()
                    ->label(__('messages.t_ap_comment')),
            ])
            ->columns(1);
    }

    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->columns(1)
            ->schema([
                TextEntry::make('name')
                    ->label(__('messages.t_ap_name')),
                TextEntry::make('email')
                    ->label(__('messages.t_ap_email')),
                TextEntry::make('comment')
                    ->label(__('messages.t_ap_comment'))
                    ->markdown(),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->emptyState(view('tables.empty-state', ['message' => __('messages.t_no_blogs_comment')]))
            ->recordTitleAttribute('title')
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label(__('messages.t_ap_name'))
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make('email')
                    ->label(__('messages.t_ap_email'))
                    ->searchable()
                    ->sortable(),

                Tables\Columns\TextColumn::make('comment')
                    ->label(__('messages.t_ap_comment'))
                    ->searchable()
                    ->sortable(),
                Tables\Columns\SelectColumn::make('status')
                    ->label(__('messages.t_ap_status'))
                    ->options([
                        'pending' => 'Pending',
                        'active' => 'Active',
                        'hidden' => 'Hidden',
                    ])
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->groupedBulkActions([
                Tables\Actions\DeleteBulkAction::make(),
            ]);
    }
}
