<?php

namespace Adfox\ECommerce;

use Filament\Panel;
use Filament\Contracts\Plugin;
use Filament\Navigation\NavigationGroup;

class ECommercePlugin implements Plugin
{
    public function getId(): string
    {
        return 'eCommerce';
    }

    public function register(Panel $panel): void
    {
        $panelId = $panel->getId();

        $resourcePaths = [
            'admin' => [
                'resources' => __DIR__ . '/Filament/Resources',
                'namespace' => 'Adfox\\ECommerce\\Filament\\Resources',
                'pages' => __DIR__ . '/Filament/Pages',
                'pageNamespace' => 'Adfox\\ECommerce\\Filament\\Pages'
            ],
            'app' => [
                'resources' => __DIR__ . '/Filament/App/Resources',
                'namespace' => 'Adfox\\ECommerce\\Filament\\App\\Resources',
                'pages' => __DIR__ . '/Filament/App/Pages',
                'pageNamespace' => 'Adfox\\ECommerce\\Filament\\App\\Pages'
            ]
        ];

        if (isset($resourcePaths[$panelId])) {
            $paths = $resourcePaths[$panelId];

            $panel->discoverResources(
                in: $paths['resources'],
                for: $paths['namespace']
            )->discoverPages(
                in: $paths['pages'],
                for: $paths['pageNamespace']
            );
        }

        $panel->navigationGroups([
            NavigationGroup::make()
                ->label(__('messages.t_ecommerce_navigation'))
                ->icon('heroicon-o-shopping-bag')
        ]);
    }

    public function boot(Panel $panel): void {}
}
