<?php

namespace Adfox\ECommerce\Livewire\Payment;

use App\Traits\HelperTraits;
use App\Models\WebhookPackage;
use Livewire\Component;
use App\Models\WebhookUpgrade;
use Stripe\StripeClient;
use App\Settings\StripeSettings;
use Filament\Notifications\Notification;

class Stripe extends Component
{
    use HelperTraits;

    public $public_key;
    public $totalAmount;

    /**
     * Mount the component and set the properties if an ad ID is provided.
     */
    public function mount()
    {
        $this->public_key = app(StripeSettings::class)->public_key;
        $this->processPayment();
    }

    public function processPayment()
    {
        $total = $this->totalAmount;

        // Initialize Stripe
        $stripe = new StripeClient(app(StripeSettings::class)->secret_key); // Replace with your Stripe secret key

        try {
            $intent = $stripe->paymentIntents->create([
                'amount' => $total * 100, // total in cents
                'currency' => app(StripeSettings::class)->currency,
                'payment_method_types' => ['card']
            ]);

            $this->payment_gateway_params['client_secret'] = $intent->client_secret;

            $this->dispatch('post-created');
            $this->handleWebhookUpgrade($intent);
        } catch (\Throwable $throwable) {

            Notification::make()
                ->title(__('messages.t_error_payment_failed'))
                ->danger()
                ->body($throwable->getMessage())
                ->send();
        }
    }

    protected function handleWebhookUpgrade($intent)
    {
        try {
            if ($this->type == 'PKG') {
                WebhookPackage::create([
                    'data' => json_encode($this->data),
                    'payment_id' => $intent->id,
                    'payment_method' => 'stripe',
                    'status' => 'pending'
                ]);
            } else {
                WebhookUpgrade::create([
                    'data' => json_encode($this->data),
                    'payment_id' => $intent->id,
                    'payment_method' => 'stripe',
                    'status' => 'pending'
                ]);
            }
        } catch (\Throwable $th) {
            // Handle any exceptions
        }
    }

    public function render()
    {
        return view('e-commerce::payment.stripe');
    }
}
