<?php

namespace Adfox\ECommerce\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReturnPolicy extends Model
{
    use HasFactory, HasUuids;

    protected static function boot()
    {
        parent::boot();

        // Hook into the "creating" event
        static::creating(function ($model) {
            // Set a default value or modify attributes before creating the model
            if (empty($ad->slug)) {
                $model->user_id = auth()->id(); // Generate a slug from the title
            }
        });
    }

    protected $fillable = [
        'id',
        'policy_name',
        'description',
        'duration',
        'exceptions',
        'user_id'
    ];
}
