<?php

namespace Adfox\Flutterwave\Providers;

use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Adfox\Flutterwave\FlutterwavePlugin;
use Adfox\Flutterwave\Livewire\FlutterwavePayment;
use Livewire\Livewire;

class FlutterwaveServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new FlutterwavePlugin()));
    }

    public function boot()
    {
        Livewire::component('flutterwave-payment', FlutterwavePayment::class);
    }

}
