<div x-on:placeid-from-name="alert(1)" $el.blur(); class="flex items-center md:flex-row-reverse justify-end" x-data x-tooltip="{
    content: '{{__('messages.t_tooltip_location')}}',
    theme: $store.theme,
}">
    <button type="button" aria-label="{{__('messages.t_aria_label_location')}}" class="flex items-center md:flex-row-reverse justify-end" @click="$store.location.open = true; document.body.style.overflow = 'hidden'">
        <span class="ml-2 whitespace-nowrap cursor-pointer line-clamp-1 w-48 text-right md:text-left"  >{{ $locationName }}</span>
        <x-icon-location class="w-6 h-6 cursor-pointer dark:text-gray-500" />
    </button>


    <!-- Modal -->
    <div x-show="$store.location.open" class="fixed inset-0 flex items-start md:pt-20 justify-center z-50 bg-black dark:bg-opacity-90 bg-opacity-50" x-cloak x-trap.noscroll="$store.location.open"
            x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0 scale-90"
            x-transition:enter-end="opacity-100 scale-100"
            x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100 scale-100"
            x-transition:leave-end="opacity-0 scale-90"
        >
        <div @click.away="$store.location.open = false; document.body.style.overflow = ''" class="bg-white md:rounded-xl w-[40rem] h-full md:h-auto dark:bg-gray-800 dark:border-white/10 dark:border">
            <!-- Modal Header -->
            <div class="flex justify-between items-center px-6 py-4">
                <strong class="text-center text-lg md:text-xl">{{ __('messages.t_where_search') }}</strong>
                <button type="button" aria-label="{{__('messages.t_aria_label_close')}}" @click="$store.location.open = false; document.body.style.overflow = ''" $el.blur(); class="text-gray-400 hover:text-gray-600">
                    <x-icon-close class="w-4 h-4 md:w-5 md:h-5 classic:text-black"/>
                </button>
            </div>
            <!-- Modal Body -->
            <div class="bg-gray-50 dark:bg-gray-950 px-6 py-6 rounded-b-xl h-full md:h-auto classic:bg-gray-100 ">

                <input id="location-input" name="search" type="text" placeholder="{{ __('messages.t_address_city_province') }}" class="focus-within:ring-2 focus-within:ring-primary-600 focus-within:border-white classic:ring-0 dark:ring-0 w-full px-4 py-3 border border-gray-200 dark:border-white/10 rounded-xl rounded-b-none bg-white classic:border-black dark:bg-gray-800" @input="$store.location.updateLocations($event.target.value)">
                <div class="border-x border-b border-gray-200 dark:border-white/10 rounded-b-xl bg-white classic:border-black dark:bg-gray-800">
                    <!-- Current Location Section -->
                    <button aria-label="{{__('messages.t_aria_label_use_current_location')}}" type="button" @click='$store.location.getLocation($wire);' class="flex items-center  gap-x-2 px-4 py-3 cursor-pointer">
                        <x-icon-location class="w-6 h-6 dark:text-gray-500"/>
                        <div class="text-left">
                            <div >{{ __('messages.t_use_current_location') }}</div>
                            <div x-data="{ locationFetch: @entangle('locationFetch') }" class="text-green-600" x-show="locationFetch">{{  __('messages.t_locating_you') }}</div>
                            <div x-data="{ locationBlocked: @entangle('locationBlocked') }" class="text-gray-400 text-sm" x-show="locationBlocked">{{ __('messages.t_location_blocked') }}</div>
                        </div>
                    </button>
                    <!-- Locations from Google -->
                    <div class="px-4 border-t border-gray-200 dark:border-white/10 classic:border-black" x-show="$store.location.locations && $store.location.locations.length > 0">
                        <template x-for="location in $store.location.locations" :key="location.description">
                            <div
                            @click="$store.location.selectLocation(location.place_id, $wire, 'location-redirect'); $store.location.open = false; document.body.style.overflow = ''; "
                            @keydown.enter="$store.location.selectLocation(location.place_id, $wire, 'location-redirect');
                            $store.location.open = false;
                            document.body.style.overflow = '';"
                            @keydown.space.prevent="$store.location.selectLocation(location.place_id, $wire, 'location-redirect');
                                    $store.location.open = false;
                                    document.body.style.overflow = '';"
                            class="flex items-center my-4 cursor-pointer"
                            role="button"
                            tabindex="0"
                            x-bind:aria-label="location.description"
                            >
                                <span class="ml-2" x-text="location.description"></span>
                            </div>
                        </template>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@script
<script>
        Alpine.store('location', {
                    open: false,
                    locations: [],
                    init(){
                        if($wire.canAutoDetect){
                            $store.location.getLocation($wire);
                        }
                    },
                    getLocation(wire) {
                        wire.set('locationFetch', true);
                        navigator.geolocation.getCurrentPosition(position => {
                            const latitude = position.coords.latitude;
                            const longitude = position.coords.longitude;
                            const GOOGLE_API_KEY = "{{ $this->googleSettings?->api_key }}";
                            // Call the geocoding API to fetch the location name
                            fetch(`https://maps.googleapis.com/maps/api/geocode/json?latlng=${latitude},${longitude}&key=${GOOGLE_API_KEY}`)
                            .then(response => response.json())
                            .then(data => {
                                if (data.results && data.results.length > 0) {
                                    const placeId = data.place_id;
                                    const addressComponents = data.results[0].address_components;
                                    const city = addressComponents.find(comp => comp.types.includes('locality') ||comp.types.includes('administrative_area_level_3'))?.short_name;
                                    const state = addressComponents.find(comp => comp.types.includes('administrative_area_level_1') || comp.types.includes('administrative_area_level_2'))?.short_name;
                                    const country = addressComponents.find(comp => comp.types.includes('country'))?.long_name;
                                    const area = addressComponents.find(comp => comp.types.includes('sublocality') ||comp.types.includes('neighborhood') || comp.types.includes('sublocality_level_1'))?.short_name;
                                    const postalCode = addressComponents.find(comp => comp.types.includes('postal_code'))?.short_name;
                                    const locationName = this.formatLocation(area,city,state,country);

                                    let locationType = 'area';
                                    wire.set('latitude', latitude);
                                    wire.set('longitude', longitude);
                                    wire.set('locationName', locationName);  // Set the location name in the component
                                    wire.set('locationBlocked', false);
                                    wire.set('locationFetch', false);
                                    $store.location.open = false;
                                    document.body.style.overflow = 'auto';

                                    let locationSlug;
                                    if (area) {
                                        locationType = 'area';
                                        locationSlug = area;
                                    } else if (city) {
                                        locationType = 'city';
                                        locationSlug = city;
                                    } else if (state) {
                                        locationType = 'state';
                                        locationSlug = state;
                                    } else if (country) {
                                        locationType = 'country';
                                        locationSlug = country;
                                    }

                                    wire.storeLocationInSession(latitude, longitude, locationName, country, state, city, locationType);

                                    $wire.dispatch('location-redirect', { locationSlug });
                                }
                            })
                            .catch(error => {
                                console.error("Error fetching the location name:", error);
                            });

                        }, () => {
                            wire.set('locationBlocked', true);
                            wire.set('locationFetch', false);
                        });
                    },
                    updateLocations(inputValue) {
                        var allowedCountries =  @json($this->locationSettings->allowed_countries);

                        if (!inputValue) {
                            this.locations = [];
                            return;
                        }
                        // Get place predictions
                        const service = new google.maps.places.AutocompleteService();
                        service.getPlacePredictions({ input: inputValue, componentRestrictions: { country: allowedCountries } }, (predictions, status) => {
                            if (status === google.maps.places.PlacesServiceStatus.OK) {
                                this.locations = predictions;
                            }
                        });
                    },
                    selectLocation(placeId, wire, type) {
                        const service = new google.maps.places.PlacesService(document.getElementById('location-input'));

                        service.getDetails({ placeId: placeId }, (place, status) => {
                            if (status === google.maps.places.PlacesServiceStatus.OK) {

                                const latitude = place.geometry.location.lat();
                                const longitude = place.geometry.location.lng();
                                // Extract required components from address components
                                const addressComponents = place.address_components;
                                const postalCode = addressComponents.find(comp => comp.types.includes('postal_code'))?.short_name;
                                const city = addressComponents.find(comp => comp.types.includes('locality') ||comp.types.includes('administrative_area_level_3'))?.short_name;
                                const state = addressComponents.find(comp => comp.types.includes('administrative_area_level_1'))?.short_name;
                                const country = addressComponents.find(comp => comp.types.includes('country'))?.long_name;
                                const area = addressComponents.find(comp => comp.types.includes('sublocality') ||comp.types.includes('neighborhood') || comp.types.includes('sublocality_level_1'))?.short_name;

                                const locationName = this.formatLocation(area,city,state,country);
                                let locationType;
                                let locationSlug;
                                if (area) {
                                    locationType = 'area';
                                    locationSlug = area;
                                } else if (city) {
                                    locationType = 'city';
                                    locationSlug = city;
                                } else if (state) {
                                    locationType = 'state';
                                    locationSlug = state;
                                } else if (country) {
                                    locationType = 'country';
                                    locationSlug = country;
                                }
                                wire.set('locationName', locationName);
                                wire.set('latitude', latitude);
                                wire.set('longitude', longitude);
                                // wire.set('city', city);
                                // wire.set('state', state);
                                // wire.set('country', country);
                                // wire.set('postal_code', postalCode);

                                wire.storeLocationInSession(latitude, longitude, locationName, country, state, city, locationType);

                                if(type == 'location-redirect') {
                                    $wire.dispatch('location-redirect', { locationSlug });
                                }
                            }
                        });
                    },
                    formatLocation(area,city,state,country){
                        let location='';
                        if(area) location += area;
                        if(city) location += area?`, ${city}`:city;
                        if(state) location += (area||city) ?` - ${state}`:(location.length==0?state +' - '+country:state);
                        if(location.length==0) location += country
                        return location;
                    }
        });


        document.addEventListener('livewire:initialized', () => {

                let locationName = $wire.$get('locationSlug');
                const GOOGLE_API_KEY = "{{ $this->googleSettings?->api_key }}";
                // Call the geocoding API to fetch the location name
                fetch(`https://maps.googleapis.com/maps/api/geocode/json?address=${locationName}&&key=${GOOGLE_API_KEY}`)
                .then(response => response.json())
                .then(data => {
                    if (data.results && data.results.length > 0) {
                        const placeId = data.results[0].place_id;
                        $store.location.selectLocation(placeId, $wire);
                    } else {
                        // console.error('No results found');
                    }
                })
                .catch(error => console.error('Error:', error));

        });
</script>
@endscript
