<?php

namespace Adfox\LoginOtp\Livewire;

use App\Models\MobileVerificationCode;
use App\Models\User;
use App\Settings\LoginOtpSettings;
use Carbon\Carbon;
use Exception;
use Filament\Notifications\Notification;
use Livewire\Attributes\On;
use Livewire\Component;
use Twilio\Rest\Client;

class SendOtp extends Component
{
    public $phoneNumber;
    public $otp;

    //listen event from javascript
    #[On('sendOtp')]
    /**
     * Send Otp to the phone number
     *
     * @param  mixed $number -> user mobile number
     * @return void
     */
    public function sendOtp($number,$from=null)
    {

        $this->phoneNumber = $number;
        $this->otp = $this->generateOtp();
        $loginOtpSettings = app(LoginOtpSettings::class);

        if (!$this->phoneNumber) {
            return redirect()->route('verification.notice');

        }
        //validate phone number is exist
        $this->validate([
            'phoneNumber' => 'required|exists:users,phone_number'
        ]);


            try {

                $user = User::where('phone_number', $this->phoneNumber)->first();

                //  User Does not Have Any Existing OTP
                $verificationCode = MobileVerificationCode::where('user_id', $user->id)->latest()->first();

                // current time
                $now = Carbon::now();

                // if ($verificationCode && $now->isBefore(Carbon::create($verificationCode->created_at)->addMinutes(2))) {
                //     return $verificationCode;
                // }


                // twilio sid
                $sid = $loginOtpSettings->twilio_sid;

                // twilio token
                $token = $loginOtpSettings->auth_token;
                $twilio = new Client($sid, $token);

                //send otp message to the number
                $message = $twilio->messages
                    ->create(
                        $number, // to
                        array(
                            "from" => $loginOtpSettings->from_number,  //twilio from number
                            "body" =>
                            "Your One-Time Password (OTP) for login is: {$this->otp}.
Use this OTP to securely access your account. Please do not share it with anyone. It expires in 5 minutes.
If you didn't request this OTP, please contact support immediately.",
                            // 'statusCallback' => config('app.url').'/twilio/callback',
                        )
                    );
                if ($message->status == 'queued') {

                    //create verification code record
                    MobileVerificationCode::create([
                        'user_id' => $user->id,
                        'otp' => $this->otp,
                        'expire_at' => Carbon::now()->addMinutes(5)
                    ]);
                    if ($from=='resend') {
                        //return success message
                        session()->flash('status', 'otp-success');
                    }
                    return redirect()->route('verifyOtp',['userId'=>$user->id]);
                } else {

                    //return success message
                   return redirect()->back()->with('status', 'otp-failed');
                }
            } catch (Exception $e) {

                 //return error message
                return redirect()->back()->with('status', $e->getMessage());

        }

    }

    /**
     * generate Otp
     *
     * @return number
     */
    public function generateOtp()
    {
        // create 6 digit otp number
        return rand(123456, 999999);
    }


    public function render()
    {
        return view('login-otp::send-otp')->extends('login-otp::layouts.auth')->section('content');
    }
}
