<div class="map-container " wire:ignore.self teleport>
    <div id="map" style="height: 100%; width: 100%;"
        class="w-full shadow-sm flex-none bg-white  transition-all dark:bg-gray-900   flex flex-col {{ app('filament')->hasPlugin('map-view') && $mapViewSettings->enable && $mapViewSettings->enable_container_max_width ? 'classic:md:rounded-t-xl' : 'classic:md:rounded-tl-xl' }}"
        wire:ignore :class="{ 'classic:border-black classic:border classic:border-b-0 ': !showFullScreenMap }"></div>
    @if ($selectedAd)
        <div id="listing-details" class="md:!w-[45%] !w-[70%] max-w-72" wire:ignore.self>
            <livewire:ad.ad-item :ad="$selectedAd" wire:key="related-{{ $selectedAd->id }}" lazy="false" />
        </div>
    @endif
    @if ($this->canDisplayLocationCount)
            <div id="listing-details-map" class="md:hidden absolute bottom-3 left-2 grid grid-flow-col auto-cols-max overflow-x-auto gap-x-2 w-full">
                @foreach ($ads as $ad)
                <div class=" max-w-44" wire:key="related-{{ $ad->id }}">
                    <livewire:ad.ad-item currentView='grid' key="related-ad-item-{{ $ad->id }}" :ad="$ad"  lazy="false" />
                </div>
                @endforeach
            </div>
    @endif

    <style>
        .map-container {
            position: relative;
            /* width: 500px; */
            height: 100%;

        }
        #listing-details-map{
            /* position: absolute;
            bottom: 10px;
            left: 5px; */
            /* z-index: 9999; */
            border-radius: 8px;
        }
        #listing-details {
            position: absolute;
            width: 300px;
            top: 25%;
            left: 50%;
            transform: translate(-50%, 0);
            z-index: 9999;
            border-radius: 8px;
        }

        .price-tag {
            background-color: white;
            border-radius: 8px;
            font-size: 14px;
            padding: 5px 11px;
            font-weight: 500;
            position: relative;
            border: 1px solid black;
        }


        a[href^="http://maps.google.com/maps"]{display:none !important}
        a[href^="https://maps.google.com/maps"]{display:none !important}

        .gmnoprint a, .gmnoprint span, .gm-style-cc {
            display:none;
        }
        .gmnoprint div {
            background:none !important;
        }
    </style>

</div>


@script
    <script>
        const mapElement = document.getElementById('map');
        const ads = @json($ads);
        const adsCountByLocation = @json($adsCountByLocation);
        const canDisplayLocationCount = @json($this->canDisplayLocationCount);
        let currentMarkers = []; // Array to track all active markers

        updateMarkers(canDisplayLocationCount ? adsCountByLocation : ads);

        function getMapOptions() {
            return {
                center: {
                    lat: 0,
                    lng: 0
                },
                zoom: 2,
                mapId: '4504f8b37365c3d0',
                scrollwheel: true,
                mapTypeControl: false,
                streetViewControl: false,
                fullscreenControl: false,
                zoomControlOptions: {
                    position: google.maps.ControlPosition.RIGHT_CENTER,
                },
                gestureHandling: window.innerWidth < 1024 ? 'greedy' : 'auto'
            }
        }
        async function loadGoogleMapLibraries() {
            try {
                const {
                    Map
                } = await google.maps.importLibrary("maps");
                const {
                    AdvancedMarkerElement
                } = await google.maps.importLibrary("marker");
                return {
                    Map,
                    AdvancedMarkerElement
                };
            } catch (error) {
                console.log('Error loading google map libraries', error);
            }
        }
        async function updateMarkers(ads) {
            try {
                const {
                    Map,
                    AdvancedMarkerElement
                } = await loadGoogleMapLibraries();
                const map = new Map(mapElement, getMapOptions());
                const bounds = new google.maps.LatLngBounds();


                if (!bounds.isEmpty()) {
                    map.fitBounds(bounds);
                }

                if(canDisplayLocationCount){
                    //Location count
                    Object.keys(ads).forEach(function(location, index) {
                        addCountMarkerToMap(location,ads[location], map, AdvancedMarkerElement, bounds);
                    });
                    map.addListener('click', () => {
                    //reset selected ad property
                    Livewire.dispatch('clear-location-filter');
                });
                }
                else{
                ads.forEach(ad => addMarkerToMap(ad, map, AdvancedMarkerElement, bounds));
                // Close listing details when clicking outside
                map.addListener('click', () => {
                    const listingDetails = document.getElementById('listing-details');
                    listingDetails.classList.add('hidden');
                    //reset selected ad property
                    Livewire.dispatch('select-ad', {
                        adId: null
                    });
                });
            }
            } catch (error) {
                console.error('Error updating markers:', error);
            }
        }

        function addMarkerToMap(ad, map, AdvancedMarkerElement, bounds) {
            if (ad.latitude && ad.longitude) {
                const position = {
                    lat: parseFloat(ad.latitude),
                    lng: parseFloat(ad.longitude)
                };
                let marker;
                //if mapLabel is available create advance marker element else create marker
                if (ad.mapLabel) {
                    //create price element
                    const priceTag = document.createElement("button");
                    priceTag.className = "price-tag dark:bg-gray-700 dark:text-gray-400";
                    priceTag.textContent = ad.mapLabel;

                    //create custom marker element
                    marker = new AdvancedMarkerElement({
                        position: position,
                        map: map,
                        content: priceTag
                    });
                } else {
                    marker = new google.maps.Marker({
                        position: position,
                        map: map,
                    });
                }
                if (marker) currentMarkers.push(marker);
                bounds.extend(position);

                marker.addListener('click', (event) => {
                    Livewire.dispatch('select-ad', {
                        adId: ad.id
                    });


                    waitForElement('#listing-details', function(element) {
                        // Once the element exists, remove hidden
                        element.classList.remove('hidden');
                    });
                });
            }
        }

        function addCountMarkerToMap(location,locationCount, map, AdvancedMarkerElement, bounds) {

            const locationArray=location.split(',');
            const latitude=locationArray[0];
            const longitude=locationArray[1];

            if (latitude && longitude) {
                const position = {
                    lat: parseFloat(latitude),
                    lng: parseFloat(longitude)
                };
                let marker;
                //if locationCount is available create advance marker element else create marker
                if (locationCount) {
                    //create price element
                    const priceTag = document.createElement("button");
                    priceTag.className = "price-tag dark:bg-gray-700 dark:text-gray-400";
                    priceTag.textContent = locationCount;

                    //create custom marker element
                    marker = new AdvancedMarkerElement({
                        position: position,
                        map: map,
                        content: priceTag
                    });
                } else {
                    marker = new google.maps.Marker({
                        position: position,
                        map: map,
                    });
                }

                if (marker) currentMarkers.push(marker);
                bounds.extend(position);

                marker.addListener('click', (event) => {
                    Livewire.dispatch('select-location', {
                        latitude: latitude,
                        longitude: longitude,
                    });
                });
            }
        }
        //update markers
        Livewire.on('ads-updated', function(ads) {
            clearMarkers();
            updateMarkers(ads.ads);

        })

        function clearMarkers() {
            currentMarkers.forEach(marker => {
                marker.setMap(null);
            });
            currentMarkers = [];
        }

        function waitForElement(selector, callback) {
            //check if the browser supports MutationObserver otherwise use setInterval
            if (typeof MutationObserver !== 'undefined') {
                // Use MutationObserver to detect changes in the DOM
                const observer = new MutationObserver((mutations, me) => {
                    const element = document.querySelector(selector);
                    if (element) {
                        // If the element exists, stop the observer and execute the callback
                        me.disconnect();
                        callback(element);
                    }
                });

                // Start observing the document for changes
                observer.observe(document, {
                    childList: true,
                    subtree: true
                });
            } else {
                const elementInterval = setInterval(() => {
                    const element = document.querySelector(selector);
                    if (element) {
                        // If the element exists, stop the interval and execute the callback
                        clearInterval(elementInterval);
                        callback(element);
                    }
                }, 0);
            }
        }

    </script>
@endscript
