<?php

namespace Adfox\MapView;

use Filament\Navigation\NavigationGroup;
use Filament\Panel;
use Filament\Contracts\Plugin;

class MapViewPlugin implements Plugin
{
    public function getId(): string
    {
        return 'map-view';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\MapView\\Filament\\Resources'
            )
                ->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\MapView\\Filament\\Pages'
                );
            ;
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
