<?php

namespace Adfox\Mollie\Http\Controllers\Callback;


use App\Http\Controllers\Controller;
use App\Models\{WebhookUpgrade, WebhookPackage};
use App\Settings\MollieSettings;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Traits\HandlesPromotionApplication;
use App\Traits\HandlesPackageApplication;
use Mollie\Api\MollieApiClient;

class MollieController extends Controller
{
    private $mollieSettings;
    use HandlesPackageApplication;
    use HandlesPromotionApplication;
    /**
     * Handle the callback from the Stripe payment gateway.
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function callback(Request $request)
    {
        $this->mollieSettings = app(MollieSettings::class);

        $paymentId = $request->query('payment_id');;


        // Check webhook event
        if ($paymentId) {

            $response = $this->verifyPayment($paymentId);

            if (is_array($response) && $response['success'] == TRUE) {

                // Get order id
                $order_id = $response['response']['order_id'];

                // Check If Package Management Callback
                if (Str::startsWith($order_id, "PKG-")) {

                    $orderData = WebhookPackage::where('payment_id', $order_id)
                        ->where('payment_method', 'mollie')
                        ->where('status', 'pending')
                        ->firstOrFail();

                    $routeParameters = $this->applyPackages($orderData);

                    return redirect()->route('package-success', $routeParameters);

                } else {


                    $orderData = WebhookUpgrade::where('payment_id', $order_id)
                        ->where('payment_method', 'mollie')
                        ->where('status', 'pending')
                        ->firstOrFail();
                    $routeParameters = $this->applyPromotionsWithRedirect($orderData);

                    return redirect()->route('success-upgrade', $routeParameters);
                }
            }
        }

        return redirect('/');
    }


    /**
     * Verify if payment succeeded
     *
     * @param string $id
     * @return array
     */
    private function verifyPayment($paymentId)
    {
        try {

            $mollie = new MollieApiClient();
            // Set api key
            $mollie->setApiKey($this->mollieSettings->api_key);
            $payment = $mollie->payments->get($paymentId);

            if ($payment->isPaid()) {
                
                $data['order_id'] = $payment->metadata->order_id;
                return [
                    'success' => true,
                    'response' => $data
                ];

            } else {

                // Failed
                return [
                    'success' => false,
                    'message' => __('messages.t_error_payment_failed')
                ];

            }

        } catch (\Throwable $th) {

            // Error
            return [
                'success' => false,
                'message' => __('messages.t_toast_something_went_wrong')
            ];

        }
    }

}

