<?php

namespace Adfox\OfflinePayment\Filament\Pages;

use App\Settings\OfflinePaymentSettings;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;
use Illuminate\Support\Facades\Config;

class OfflinePayment extends SettingsPage
{
    use HasPageShield;

    protected static ?string $slug = 'manage-offline-payment-settings';

    protected static string $settings = OfflinePaymentSettings::class;


    public static function getNavigationBadgeTooltip(): ?string
    {
        return 'Offline Payment Module (Addon) - Accept and manually verify bank transfers and other offline payment methods. Requires separate purchase.';
    }

    public static function getNavigationBadge(): ?string
    {
        $isDemo = Config::get('app.demo');
        return  $isDemo  ? 'Addon' : '';
    }

    public static function getNavigationBadgeColor(): ?string
    {
        return 'danger';
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_OfflinePayment');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_offline_payment');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_payment_gateways');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_offline_payment');
    }
    protected function mutateFormDataBeforeSave(array $data): array
    {
        // Get current settings instance (to compare and ensure correct data)
        $previousData = app(OfflinePaymentSettings::class);
        $filtered = [];

        // Handling the 'payment_type' repeater field
        if (isset($data['payment_type'])) {
            $paymentDetails = [];

            // Iterate through the repeater data and map it to 'name' and 'instruction'
            foreach ($data['payment_type'] as $detail) {
                $paymentDetails[] = [
                    'name' => $detail['name'] ?? '',        // Ensure empty string if no data is provided
                    'instruction' => $detail['instruction'] ?? '',
                ];
            }

            // Save the formatted data as 'payment_type' in the settings
            $data['payment_type'] = $paymentDetails;
        }

        // Process the rest of the form data
        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }

        return $filtered;
    }

    // public function mount():void
    // {
    //        // Get the current settings instance
    //     $settings = app(OfflinePaymentSettings::class);
    //        // Extract 'payment_type' data to pass it to the form default value
    //     $offlinePaymentDetails = $settings->payment_type ?? [];  // Load sav
    //     $this->form->fill([
    //         'payment_type' => $offlinePaymentDetails,
    //     ]);
    // }

    public function form(Form $form): Form
    {
        $currenciesConfig = config('money.currencies');
        $currencyCodes = array_keys($currenciesConfig);

        return $form
            ->schema([
                Toggle::make('status')
                    ->label(__('messages.t_ap_enable_offline_payment_label'))
                    ->helperText(__('messages.t_ap_enable_offline_payment_helper_text')),

                Textarea::make('instruction')
                    ->label(__('messages.t_ap_payment_instructions_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_payment_instructions_helper_text')),

                Select::make('currency')
                    ->label(__('messages.t_ap_default_currency_label'))
                    ->options(array_combine($currencyCodes, $currencyCodes))
                    ->required()
                    ->helperText(__('messages.t_ap_default_currency_helper_text')),

                TextInput::make('exchange_rate')
                    ->label(__('messages.t_ap_exchange_rate_label'))
                    ->numeric()
                    ->required()
                    ->helperText(__('messages.t_ap_exchange_rate_helper_text')),

                    Repeater::make('payment_type')
                    ->label(__('messages.t_ap_payment_method_details'))
                    ->schema([
                        TextInput::make('name')
                            ->label(__('messages.t_ap_payment_method_name'))
                            ->required()
                            ->helperText(__('messages.t_ap_payment_method_name_description')),

                        Textarea::make('instruction')
                            ->label(__('messages.t_ap_payment_instructions'))
                            ->required()
                            ->helperText(__('messages.t_ap_payment_instructions_description')),
                    ])
                    ->addActionLabel(__('messages.t_ap_add_payment_method'))
                    ->collapsible()
                    ->minItems(1)
                    ->helperText(__('messages.t_ap_configure_payment_options'))
                    ->columnSpan('full'),
                    // ->default($offlinePaymentDetails) // Default values from 'payment_type'
            ])
            ->columns(2);
    }
}
