<div>
    <div
        class="bg-balack p-4 shadow-sm rounded-lg mb-6 border border-gray-200 dark:border-white/10 classic:border-black">
        <!-- Summary Header -->
        <h3 class="text-lg font-semibold border-b border-gray-200  dark:border-white/10 classic:border-black pb-2 mb-4">
            {{ __('messages.t_summary') }}</h3>

        <!-- Dynamic Package Details -->
        @foreach ($packageItems as $item)
        <div wire:key='summary-package-{{ $item->id }}' class="flex justify-between py-1">
            <span>
                @if($item->promotion)
                {{ __('messages.t_promotion_name_for_days', ['quantity' => $item->quantity, 'promotionName' =>
                $item->promotion->promotion->name, 'days' => $item->promotion->package->duration]) }}
                @else
                {{ __('messages.t_ads_valid_for_days', ['quantity' => $item->quantity, 'days' =>
                $item->package->duration]) }}
                @endif
            </span>

            <!-- Display the price, using the offer price if available and within the offer date range -->
            @php
            $today = \Illuminate\Support\Carbon::now();
            $isOfferValid = $item->offer_enabled && $item->offer_price && $today->between($item->offer_start,
            $item->offer_end);
            @endphp

            <span>
                @if($isOfferValid)
                <s>{{ formatPriceWithCurrency($item->price) }}</s>
                {{ formatPriceWithCurrency($item->offer_price) }}
                @else
                 {{ formatPriceWithCurrency($item->price) }}
                @endif
            </span>
        </div>
        @endforeach

        <!-- Divider -->
        <div class="border-t my-3 border-gray-200  dark:border-white/10 classic:border-black"></div>

        <!-- Subtotal -->
        <div class="flex justify-between py-1">
            <span class="font-semibold">{{ __('messages.t_subtotal') }}</span>
            <span>{{ formatPriceWithCurrency($subtotal) }}
</span>
        </div>

        <!-- Tax -->
        <div class="flex justify-between py-1">
            <span>{{ __('messages.t_tax') }}</span>
            <span>{{ formatPriceWithCurrency($tax) }}</span>
        </div>

        <!-- Divider -->
        <div class="border-t my-3 border-gray-200  dark:border-white/10 classic:border-black"></div>

        <!-- Total -->
        <div class="flex justify-between py-1">
            <span class="font-semibold text-lg">{{ __('messages.t_total') }}</span>
            <span class="font-semibold text-lg">{{ formatPriceWithCurrency($total) }}</span>
        </div>

        {{-- Exchange Rate --}}
        @if ($this->defaultCurrency && $this->isDifferentRate)
        <div class="flex justify-between py-1">
            <span class="font-semibold text-lg">{{ __('messages.t_total_including_exchange_rate') }}</span>
            <span class="font-semibold text-lg">{{ formatPriceWithCurrency($this->convertedTotal) }}</span>
        </div>
        @endif
    </div>

    <div class=" flex flex-col md:flex-row justify-between gap-2 md:gap-4">
        <div class="w-full">
            <h3 class="mb-6">{{ __('messages.t_choose_payment_label') }}</h3>
            @if(count($this->initializePaymentOptions()) >= 1)
            <form wire:submit>
                <div class="mb-5 payment-methods">
                    {{ $this->form }}
                </div>
            </form>
            @else
            @include('components.empty-payment')
            @endif
        </div>
        <div class="w-full">
            @if ($currentPayment)
            <livewire:dynamic-component :key="$currentPayment" :component="$currentPayment" :data="$this->paymentData"
                :total="$this->defaultCurrency && $this->isDifferentRate ? $this->convertedTotal : $total" :$id
                :$subtotal :$tax :$type :$selectedPaymentMethod />
            @endif
        </div>
    </div>
</div>
