<?php

namespace Adfox\Packages\Livewire;

use App\Models\Ad;
use App\Settings\GeneralSettings;
use App\Settings\SEOSettings;
use Livewire\Attributes\Url;
use Livewire\Component;
use Artesaos\SEOTools\Traits\SEOTools as SEOToolsTrait;

class PackageSuccess extends Component
{
    use SEOToolsTrait;

    public $actionType;

    public $isMobileHidden = false;

    #[Url]
    public $ad_id;

    public $ad;

    /**
     * Initialize the component with the specified action type and load the associated Ad.
     *
     * @param string $actionType The type of action that has been performed.
     */
    public function mount($actionType)
    {
        $this->actionType = $actionType;
        $this->loadAd();
        $this->setSeoData();
    }

     /**
    * Set SEO data
    */
    protected function setSeoData()
    {
        $generalSettings = app(GeneralSettings::class);
        $seoSettings = app(SEOSettings::class);


        $separator = $generalSettings->separator ?? '-';
        $siteName = $generalSettings->site_name ?? app_name();

        $title = __('messages.t_general_success') . " $separator " . $siteName;
        $description = $seoSettings->meta_description;

        $this->seo()->setTitle($title);
        $this->seo()->setDescription($description);
    }

    /**
     * Load the Ad model if an Ad ID is provided.
     */
    protected function loadAd()
    {
        if ($this->ad_id) {
            $this->ad = Ad::find($this->ad_id);
            // Optionally add error handling if the Ad is not found
        }
    }

    /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public function render()
    {
        return view('packages::package-success');
    }
}
