<?php

namespace Adfox\Paypal\Filament\Pages;

use App\Settings\PaypalSettings;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use App\Models\SettingsProperty;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Components\ToggleButtons;
use Illuminate\Support\Facades\Config;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class PaypalPayment extends SettingsPage
{
    use HasPageShield;


    protected static ?string $slug = 'manage-paypal-settings';

    protected static string $settings = PaypalSettings::class;

    protected static ?int $navigationSort = 11; // Adjust the sort order as needed

    public static function canAccess(): bool
    {
        return userHasPermission('page_PaypalPayment');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_paypal_settings');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_payment_gateways');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_paypal_settings');
    }
    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(PaypalSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $currenciesConfig = config('money.currencies');
        $currencyCodes = array_keys($currenciesConfig);
        $isDemo = Config::get('app.demo');
        return $form
            ->schema([
                TextInput::make('name')
                    ->label(__('messages.t_ap_paypal_name_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_paypal_name_helper_text')),

                Toggle::make('status')
                    ->label(__('messages.t_ap_enable_paypal_label'))
                    ->helperText(__('messages.t_ap_enable_paypal_helper_text')),

                ToggleButtons::make('mode')
                    ->options([
                        'sandbox' => __('messages.t_ap_sandbox_label'),
                        'live' => __('messages.t_ap_live_label')
                    ])
                    ->inline()
                    ->label(__('messages.t_ap_payment_mode_label'))
                    ->helperText(__('messages.t_ap_payment_mode_helper_text'))
                    ->required(),

                SpatieMediaLibraryFileUpload::make('logo')
                    ->maxSize(maxUploadFileSize())
                    ->label(__('messages.t_ap_paypal_logo_label'))
                    ->collection('paypal')
                    ->visibility('public')
                    ->hidden()
                    ->image()
                    ->model(
                        SettingsProperty::getInstance('paypal.logo'),
                    )
                    ->helperText(__('messages.t_ap_paypal_logo_helper_text')),

                Select::make('currency')
                    ->label(__('messages.t_ap_default_currency_label'))
                    ->options(array_combine($currencyCodes, $currencyCodes))
                    ->required()
                    ->helperText(__('messages.t_ap_default_currency_helper_text')),

                $isDemo ?
                Placeholder::make('client_id')
                    ->label(__('messages.t_ap_paypal_client_id_label'))
                    ->content('*****')
                    ->hint(__('messages.t_ap_paypal_client_id_hint')) :
                TextInput::make('client_id')
                    ->label(__('messages.t_ap_paypal_client_id_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_paypal_client_id_helper_text')),

                $isDemo ?
                Placeholder::make('client_secret')
                    ->label(__('messages.t_ap_paypal_client_secret_label'))
                    ->content('*****')
                    ->hint(__('messages.t_ap_paypal_client_secret_hint')) :
                TextInput::make('client_secret')
                    ->label(__('messages.t_ap_paypal_client_secret_label'))
                    ->required()
                    ->helperText(__('messages.t_ap_paypal_client_secret_helper_text')),

                TextInput::make('exchange_rate')
                    ->label(__('messages.t_ap_exchange_rate_label'))
                    ->numeric()
                    ->required()
                    ->helperText(__('messages.t_ap_exchange_rate_helper_text')),
            ])
            ->columns(2);
    }
}
