<?php

namespace Adfox\Payu\Http\Controllers\Callback;

use App\Http\Controllers\Controller;
use App\Models\WebhookUpgrade;
use App\Models\WebhookPackage;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Traits\HandlesPromotionApplication;
use App\Traits\HandlesPackageApplication;
use Tzsk\Payu\Concerns\Attributes;
use Tzsk\Payu\Concerns\Customer;
use Tzsk\Payu\Concerns\Transaction;
use Tzsk\Payu\Facades\Payu;
use Tzsk\Payu\Models\PayuTransaction;

class PayuController extends Controller
{
    use HandlesPackageApplication, HandlesPromotionApplication;

    /**
     * Create a new PayU payment.
     */
    public function createPayment(Request $request)
    {
        $customer = Customer::make()
            ->firstName(auth()->user()->name)
            ->email(auth()->user()->email);

        // Optional custom attributes
        $attributes = Attributes::make()->udf1('anything');

        $transaction = Transaction::make()
            ->charge($request->total)
            ->id($request->id)
            ->for('Product')
            ->with($attributes) // Include custom attributes if any
            ->to($customer);

        return Payu::initiate($transaction)->redirect(route('payu.callback', $request->id));
    }

    /**
     * Handle the callback from PayU.
     */
    public function callback($id)
    {
        $payu = PayuTransaction::where('transaction_id', $id)->firstOrFail();

        if ($payu->status === 'successful') {
            if (Str::startsWith($id, 'PKG-')) {
                $orderData = WebhookPackage::where('payment_id', $id)
                    ->where('payment_method', 'payu')
                    ->where('status', 'pending')
                    ->firstOrFail();

                $routeParameters = $this->applyPackages($orderData);

                return redirect()->route('package-success', $routeParameters);
            } else {
                $orderData = WebhookUpgrade::where('payment_id', $id)
                    ->where('payment_method', 'payu')
                    ->where('status', 'pending')
                    ->firstOrFail();

                $routeParameters = $this->applyPromotionsWithRedirect($orderData);

                return redirect()->route('success-upgrade', $routeParameters);
            }
        }

        return redirect('/');
    }
}
