<?php

namespace Adfox\Payu\Livewire;

use App\Models\WebhookPackage;
use App\Models\WebhookUpgrade;
use App\Traits\HandlesPackageApplication;
use App\Traits\HandlesPromotionApplication;
use Livewire\Component;
use App\Settings\PaymentSettings;
use App\Settings\GeneralSettings;
use App\Settings\PayuSettings;

class PayuPayment extends Component
{
    use HandlesPackageApplication;
    use HandlesPromotionApplication;
    /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public $id;

    public $type;

    public $total;

    public $data;

    public $tax;

    public $subtotal;

    public $successUrl;

    public $payment_gateway_params = [];
    public $action;
    public $amount;
    public $MERCHANT_KEY;
    public $hash;
    public $txnid;
    public $name;
    public $email;
    public $successURL;
    public $failURL;

    public function getPaymentSettingsProperty()
    {
        return app(PaymentSettings::class);
    }

    public function getGeneralSettingsProperty()
    {
        return app(GeneralSettings::class);
    }

    public function getPayuSettingsProperty()
    {
        return app(PayuSettings::class);
    }

    public function createPayment()
    {
        $id = ($this->type == 'PKG' ? "PKG-" : 'MERCHANT') . rand(100000, 999999);
        $this->handleWebhookUpgrade($id);

        return redirect()->to(route('payu.create_payment') . "?type={$this->type}&total={$this->total}&id={$id}") ;
    }

    protected function handleWebhookUpgrade(string $orderId): void
    {
        try {
            $webhookData = [
                'data' => json_encode($this->data),
                'payment_id' => $orderId,
                'payment_method' => 'payu',
                'status' => 'pending',
            ];

            if ($this->type === 'PKG') {
                WebhookPackage::create($webhookData);
            } else {
                WebhookUpgrade::create($webhookData);
            }
        } catch (\Throwable $th) {
            // Log the exception or handle it as needed
        }
    }

    public function render()
    {
        return view('payu::payu-payment');
    }
}
