<?php

namespace Adfox\Phonepe\Providers;

use Adfox\Phonepe\Livewire\PhonepePayment;
use Adfox\Phonepe\PhonepePlugin;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;
use Filament\Panel;


use Illuminate\Database\Eloquent\Relations\Relation;

class PhonepeServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new PhonepePlugin()));
    }

    public function boot()
    {
        Relation::morphMap([]);
        Livewire::component('phonepe-payment', PhonepePayment::class);
    }

}
