<div>
    <div>
        <div id="paypal-button-container" wire:ignore></div>
    </div>

    @assets
    <script src="https://www.paypal.com/sdk/js?client-id={{ $this->paypalSettings?->client_id }}&vault=true"></script>
    @endassets

    @script
    <script>
        setTimeout(function() {
            // Render the PayPal button into #paypal-button-container
            paypal.Buttons({
                // Set up the subscription
                createSubscription: function(data, actions) {
                    return actions.subscription.create({
                        plan_id: "{{ $plan->paypal_plan_id }}", // The PayPal Plan ID for the subscription
                        custom_id: "{{ auth()->id() }}",
                    });
                },
                // Finalize the subscription
                onApprove: function(data, actions) {
                    window.location.href = "{{ route('subscription.success') }}";
                }

            }).render('#paypal-button-container');
        }, 0);
    </script>
    @endscript
</div>