<?php

namespace Adfox\Subscription\Livewire\PaymentMethods;

use App\Models\Plan;
use App\Settings\PaypalSettings;
use Livewire\Component;
use Filament\Notifications\Notification;

class PaypalSubscription extends Component
{
    public $id;
    public $total;
    public $tax;
    public $type;
    public $data;
    public $subtotal;
    public $priceId;
    public $planId;
    public $plan;

    public $clientSecretKey;

    public $payment_gateway_params = [];
    public $customerId;
    // public $paypalSettings;

    /**
     * Mount the component and set the properties if an ad ID is provided.
     */
    public function mount()
    {
        if (isset($this->data['price_id'])) {
            $this->priceId = $this->data['price_id'];
        }
        if (isset($this->data['plan_id'])) {
            $this->planId = $this->data['plan_id'];
            
            $this->plan = Plan::find($this->data['plan_id']);
        }
        // $this->processPayment();
        $this->dispatch('initialize-stripe-form');
    }

    public function getPaypalSettingsProperty()
    {
        return app(PaypalSettings::class);
    }
    
    public function processPayment()
    {
        try {
            $stripe = new \Stripe\StripeClient($this->stripePaymentSettings?->secret_key);
            $user = auth()->user();
            $customer = $stripe->customers->create([
                'email' => $user->email,
                'name' => $user->name,
            ]);
            $this->customerId = $customer ? $customer->id : null;
            // Create the subscription with the customer ID, price ID, and necessary options.
            // $subscription = $stripe->subscriptions->create([
            //     'customer' => $customer->id,
            //     'items' => [
            //         [
            //             'price' => $this->priceId,
            //             // For metered billing, do not pass quantity
            //             'quantity' => 1,
            //         ]
            //     ],
            //     'payment_behavior' => 'default_incomplete',
            //     'payment_settings' => ['save_default_payment_method' => 'on_subscription'
            //     ],
            //     'expand' => ['latest_invoice.payment_intent'],
            //     'metadata' => [
            //             'user_id' => auth()->id(),
            //             'plan_id' => $this->planId
            //         ]
            // ]);

            // $this->clientSecretKey = $subscription->latest_invoice->payment_intent->client_secret;
        } catch (\Throwable $throwable) {
            Notification::make()
                ->title(__('messages.t_error_payment_failed'))
                ->danger()
                ->body($throwable->getMessage())
                ->send();
        }
    }
    /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public function render()
    {
        return view('subscription::payment-methods.paypal-subscription');
    }
}
