<?php

namespace Adfox\Subscription\Notifications;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SubscriptionUpdatedNotification extends Notification
{
    use Queueable;

    public $subscription;
    /**
     * Create a new notification instance.
     */
    public function __construct($subscription)
    {
       $this->subscription = $subscription;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $planName=$this->subscription->plan?->name??'';
        $startDate= Carbon::parse($this->subscription->starts_at)->format('d/m/Y');
        $endDate=Carbon::parse($this->subscription->ends_at)->format('d/m/Y');
        $status=$this->subscription->status;
        return (new MailMessage)
        ->subject(trans('messages.t_et_subscription_updated_subject'))
        ->line(trans('messages.t_et_subscription_updated_body'))
        ->line(trans('messages.t_et_subscription_plan', ['planNickname' => $planName]))
        ->line(trans('messages.t_et_subscription_period_start', ['periodStart' => $startDate]))
        ->line(trans('messages.t_et_subscription_period_end', ['periodEnd' => $endDate]))
        ->line(trans('messages.t_et_subscription_status', ['status' => __("messages.t_{$status}")]))
        ->line(trans('messages.t_et_subscription_thank_you'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
