<?php

namespace Adfox\WalletSystem\Database\Seeders;

use App\Models\Country;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class BankSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $countryId = Country::where('name', 'India')->first()->id;

        DB::table('banks')->insert([
            [
                'id' => Str::uuid(),
                'bank_name' => 'State Bank of India',
                'bank_code' => 'SBI',
                'country_id' => $countryId,
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => Str::uuid(),
                'bank_name' => 'HDFC Bank',
                'bank_code' => 'HDFC',
                'country_id' => $countryId,
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => Str::uuid(),
                'bank_name' => 'ICICI Bank',
                'bank_code' => 'ICICI',
                'country_id' => $countryId,
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => Str::uuid(),
                'bank_name' => 'Axis Bank',
                'bank_code' => 'AXIS',
                'country_id' => $countryId,
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => Str::uuid(),
                'bank_name' => 'Punjab National Bank',
                'bank_code' => 'PNB',
                'country_id' => $countryId,
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => Str::uuid(),
                'bank_name' => 'Kotak Mahindra Bank',
                'bank_code' => 'KOTAK',
                'country_id' => $countryId,
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}
