<?php

namespace Adfox\WalletSystem\Filament\App\Resources;

use Adfox\WalletSystem\Filament\App\Resources\WalletResource\Pages;
use App\Models\Wallets\Wallet;;
use App\Models\Wallets\WalletTransaction;
use Adfox\WalletSystem\Traits\WalletHelper;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;

class WalletResource extends Resource
{
    use WalletHelper;

    protected static ?string $model = WalletTransaction::class;
    protected static ?int $navigationSort = 1;

    public static function getNavigationGroup(): string
    {
        return __('messages.t_wallet_system_navigation');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_wallet_navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('messages.t_wallet_navigation_label');
    }

    //TODO: Enable when wallet system is implemented
    // public static function isDiscovered(): bool
    // {
    //     return !is_vehicle_rental_active();
    // }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('current_balance')
                    ->default(function () {
                        return Wallet::where('user_id', auth()->id())->first()->balance;
                    })->readOnly(),
                TextInput::make('amount')
                    ->label(__('messages.t_claim_amount'))
                    ->lte('current_balance')
                    ->required(),
                Select::make('transaction_type')
                    ->options(['claim_request' => __('messages.t_claim_request')])
                    ->default('claim_request')
                    ->required()
            ]);
    }

    public static function table(Table $table): Table
    {
        $wallet = Wallet::where('user_id', auth()->id())->first();

        if (!$wallet) {
            $wallet = Wallet::create([
                'user_id' => auth()->id(),
                'balance' => 0
            ]);
        }

        return $table
            ->defaultSort('created_at', 'desc')
            ->emptyState(view('tables.empty-state', ['message' => __('messages.t_no_wallets')]))
            ->modifyQueryUsing(fn(Builder $query) => $query->where('wallet_id', $wallet->id))
            ->columns(self::initializeWalletTransactionTableColumns())
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListWallets::route('/'),
            // 'create' => Pages\CreateWallet::route('/create'),
            // 'edit' => Pages\EditWallet::route('/{record}/edit'),
        ];
    }
}
