<?php

namespace Adfox\Watermark\Filament\Pages;

use App\Models\SettingsProperty;
use App\Settings\WatermarkSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;
use Illuminate\Support\Facades\Config;

class ManageWatermarkSettings extends SettingsPage
{
    use HasPageShield;


    protected static ?string $slug = 'manage-watermark-settings';

    protected static ?int $navigationSort = 7;

    protected static string $settings = WatermarkSettings::class;

    public static function getNavigationBadgeTooltip(): ?string
    {
        return 'Watermark Module (Addon) - Automatically add watermarks to protect listing images from unauthorized use. Requires separate purchase.';
    }

    public static function getNavigationBadge(): ?string
    {
        $isDemo = Config::get('app.demo');
        return  $isDemo  ? 'Addon' : '';
    }

    public static function getNavigationBadgeColor(): ?string
    {
        return 'danger';
    }

    public static function canAccess(): bool
    {
        return userHasPermission('page_ManageWatermarkSettings');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_watermark');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_settings');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_watermark');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('enable_watermark')
                    ->label(__('messages.t_ap_enable_watermark'))
                    ->helperText(__('messages.t_ap_enable_watermark_helper')),

                Select::make('position')
                    ->label(__('messages.t_ap_watermark_position'))
                    ->selectablePlaceholder(false)
                    ->options([
                        'bottom-right' => __('messages.t_ap_bottom_right'),
                        'bottom-left' => __('messages.t_ap_bottom_left'),
                        'top-right' => __('messages.t_ap_top_right'),
                        'top-left' => __('messages.t_ap_top_left'),
                        'center' => __('messages.t_ap_center'),
                    ])
                    ->helperText(__('messages.t_ap_watermark_position_helper')),

                SpatieMediaLibraryFileUpload::make('watermark_image')
                    ->maxSize(maxUploadFileSize())
                    ->label(__('messages.t_ap_watermark_image'))
                    ->collection('watermark')
                    ->visibility('public')
                    ->image()
                    ->imageCropAspectRatio('13:6')
                    ->imageResizeMode('cover')
                    ->imageResizeTargetWidth('200')
                    ->imageResizeTargetHeight('250')
                    ->imageEditor()
                    ->disk('media')
                    ->model(SettingsProperty::getInstance('watermark.watermark_image'))
                    ->helperText(__('messages.t_ap_watermark_image_helper')),

            ])
            ->columns(2);
    }
}
