<?php

namespace Adfox\Watermark;

use Filament\Panel;
use Filament\Contracts\Plugin;

class WatermarkPlugin implements Plugin
{
    public function getId(): string
    {
        return 'watermark';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\Watermark\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\Watermark\\Filament\\Pages'
                );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
